import {
    NATIVE_MOBILE_API_INCOMING_ACTIONS,
    REMOVE_PHONE,
    UPDATE_EULA_STRINGS,
    SET_AUTH_BY_SWC,
    SAVE_SUGGESTED_LOGIN_FROM_SWC,
    SET_PRIMARY_ACTION_TRIGGERED_STATUS
} from '../actions/nativeMobileApi';

export default function am(state = {}, action) {
    switch (action.type) {
        case NATIVE_MOBILE_API_INCOMING_ACTIONS.UPDATE_SAVED_EXPERIMENTS: {
            return Object.assign({}, state, {
                experiments: Object.assign({}, state.experiments || {}, action.payload.experiments)
            });
        }

        case REMOVE_PHONE: {
            return Object.assign({}, state, {
                phone: ''
            });
        }

        case UPDATE_EULA_STRINGS: {
            return Object.assign({}, state, {
                eulaStrings: {
                    ...state.eulaStrings,
                    ...action.payload.eulaStrings
                }
            });
        }

        case SET_AUTH_BY_SWC: {
            return Object.assign({}, state, {
                isAuthBySWC: action.payload.isAuthBySWC
            });
        }

        case SAVE_SUGGESTED_LOGIN_FROM_SWC: {
            return Object.assign({}, state, {
                suggestedLoginFromSWC: action.payload.login
            });
        }

        case SET_PRIMARY_ACTION_TRIGGERED_STATUS: {
            return Object.assign({}, state, {
                isPrimaryActionTriggeredError: action.payload.isError
            });
        }

        default:
            return state;
    }
}
