import {
    CHANGE_PROCESSED_ACCOUNT,
    UPDATE_LOGIN_VALUE,
    UPDATE_PASSWORD_VALUE,
    UPDATE_2FA_PICTURES,
    CHANGE_ACTIVE_ACCOUNT,
    LOGIN_SUGGESTED_ACCOUNT,
    INPUT_LOGIN_SUCCESS,
    SHOW_ACCOUNTS_SUCCESS,
    SHOW_ACCOUNTS_FAIL,
    SWITCH_TO_MODE_ADDING_ACCOUNT,
    SWITCH_TO_MODE_EDIT,
    SWITCH_TO_MODE_WELCOME,
    CAN_REGISTER,
    SET_LOGIN_ERROR,
    SET_LOGIN_IS_ABLE_TO_RESTORE,
    SET_PASSWORD_ERROR,
    CHANGE_CAPTCHA_STATE,
    UPDATE_CAPTCHA_VALUE,
    SET_CAPTCHA_ERROR,
    SET_MAGIC_ERROR,
    SETUP_MODE,
    FORCE_OTP_METHOD,
    DOMIK_IS_LOADING,
    SWITCH_TO_MODE_MAGIC,
    UPDATE_MAGIC_TOKENS_SUCCESS,
    SWITCH_TO_MODE_RESTORE_LOGIN,
    SWITCH_TO_MODE_RESTORE_LOGIN_PROCESS,
    SWITCH_TO_MODE_RESTORE_LOGIN_RESULT,
    SET_MAGIC_SUCCESS,
    SET_TYPE_IMAGE_2FA,
    TOGGLE_LOGIN_FIELD_TYPE
} from '@blocks/authv2/actions';
import {SWITCH_TO_MODE_REGISTER_LITE} from '@blocks/authv2/actions/registerLite';
import {PUBLIC_AVATAR_SET_LOADING_STATUS} from '@blocks/avatar-displayname/actions';
import {SET_AUTH_BY_SMS_STATE} from '@blocks/authv2/actions/authBySMS';

const initialState = {};

export default function auth(state = initialState, action) {
    switch (action.type) {
        case SET_LOGIN_ERROR: {
            return Object.assign({}, state, {
                loginError: action.error
            });
        }
        case SET_LOGIN_IS_ABLE_TO_RESTORE: {
            return Object.assign({}, state, {
                isAbleToRestore: action.isAbleToRestore
            });
        }
        case SET_PASSWORD_ERROR: {
            return Object.assign({}, state, {
                passwordError: action.error
            });
        }
        case SET_CAPTCHA_ERROR: {
            return Object.assign({}, state, {
                captchaError: action.error
            });
        }
        case SET_MAGIC_ERROR: {
            return Object.assign({}, state, {
                magicError: action.error
            });
        }
        case CAN_REGISTER: {
            return Object.assign({}, state, {
                form: Object.assign({}, state.form, {
                    isCanRegister: action.isCanRegister,
                    registrationLogin: action.registrationLogin || '',
                    registrationType: action.registrationType || '',
                    registrationPhoneNumber: action.registrationPhoneNumber || '',
                    registrationCountry: action.registrationCountry || ''
                })
            });
        }
        case CHANGE_PROCESSED_ACCOUNT: {
            return Object.assign({}, state, {
                method: 'password',
                processedAccount: action.account
            });
        }
        case UPDATE_LOGIN_VALUE: {
            return Object.assign({}, state, {
                form: Object.assign({}, state.form, {
                    login: action.value || '',
                    loginError: !action.value && state.form.login ? null : state.form.loginError,
                    isForceOTP: action.value === state.form.login ? state.form.isForceOTP : false
                }),
                loginError: ''
            });
        }
        case UPDATE_PASSWORD_VALUE: {
            const shouldResetPasswordError = !(state.passwordError && state.passwordError.indexOf('captcha') > -1);

            return Object.assign({}, state, {
                form: Object.assign({}, state.form, {
                    password: action.value
                }),
                passwordError: shouldResetPasswordError ? '' : state.passwordError
            });
        }
        case UPDATE_CAPTCHA_VALUE: {
            return Object.assign({}, state, {
                form: Object.assign({}, state.form, {
                    captcha_answer: action.value
                }),
                captchaError: ''
            });
        }
        case UPDATE_2FA_PICTURES: {
            return {...state, auth2faPictures: action.auth2faPictures};
        }
        case CHANGE_ACTIVE_ACCOUNT: {
            return Object.assign({}, state, {
                authorizedAccountsDefaultUid: action.uid
            });
        }
        case LOGIN_SUGGESTED_ACCOUNT: {
            return Object.assign({}, state, {
                method: action.account.preferred_auth_method,
                processedAccount: action.account
            });
        }
        case INPUT_LOGIN_SUCCESS: {
            return Object.assign({}, state, {
                inputLogins: Object.assign({}, state.inputLogins, action.inputLogin)
            });
        }
        case SHOW_ACCOUNTS_SUCCESS: {
            const {
                authorizedAccounts,
                authorizedAccountsDefaultUid,
                unitedAccounts,
                suggestedAccounts
            } = action.accounts;

            return Object.assign({}, state, {
                authorizedAccounts,
                authorizedAccountsDefaultUid,
                unitedAccounts,
                suggestedAccounts
            });
        }
        case SHOW_ACCOUNTS_FAIL: {
            return Object.assign({}, state, {
                errors: {},
                loading: false
            });
        }
        case SWITCH_TO_MODE_ADDING_ACCOUNT: {
            return Object.assign({}, state, {
                mode: 'addingAccount'
            });
        }
        case SWITCH_TO_MODE_EDIT: {
            return Object.assign({}, state, {
                mode: 'edit'
            });
        }
        case SWITCH_TO_MODE_WELCOME: {
            return Object.assign({}, state, {
                mode: 'welcome'
            });
        }
        case SWITCH_TO_MODE_MAGIC: {
            return Object.assign({}, state, {
                isFromLoginSuggest: Boolean(action.isFromLoginSuggest)
            });
        }
        case SWITCH_TO_MODE_RESTORE_LOGIN: {
            return Object.assign({}, state, {
                mode: 'restoreLogin'
            });
        }
        case SWITCH_TO_MODE_RESTORE_LOGIN_PROCESS: {
            return Object.assign({}, state, {
                mode: 'restoreLoginProcess'
            });
        }
        case SWITCH_TO_MODE_RESTORE_LOGIN_RESULT: {
            return Object.assign({}, state, {
                mode: 'restoreLoginResult'
            });
        }
        case SETUP_MODE: {
            return Object.assign({}, state, {
                mode: action.mode
            });
        }
        case CHANGE_CAPTCHA_STATE: {
            return Object.assign({}, state, {
                isCaptchaRequired: action.isCaptchaRequired
            });
        }
        case FORCE_OTP_METHOD: {
            return Object.assign({}, state, {
                form: Object.assign({}, state.form, {
                    isForceOTP: action.isForceOTP
                })
            });
        }
        case DOMIK_IS_LOADING: {
            return Object.assign({}, state, {
                loading: action.loading
            });
        }
        case PUBLIC_AVATAR_SET_LOADING_STATUS: {
            return Object.assign({}, state, {
                loading: action.isLoading
            });
        }
        case UPDATE_MAGIC_TOKENS_SUCCESS: {
            return Object.assign({}, state, {
                magicCSRF: action.csrf,
                magicTrack: action.track
            });
        }
        case SWITCH_TO_MODE_REGISTER_LITE: {
            return Object.assign({}, state, {
                mode: 'registerLite'
            });
        }

        case SET_AUTH_BY_SMS_STATE: {
            return Object.assign({}, state, {
                authBySMS: action.payload
            });
        }

        case SET_MAGIC_SUCCESS: {
            return Object.assign({}, state, {
                isMagicSuccess: action.isMagicSuccess
            });
        }

        case SET_TYPE_IMAGE_2FA: {
            return Object.assign({}, state, {
                typeImage2FA: action.typeImage2FA
            });
        }

        case TOGGLE_LOGIN_FIELD_TYPE: {
            return Object.assign({}, state, {
                loginFieldType: action.loginFieldType
            });
        }

        default:
            return state;
    }
}
