import {
    SET_CHALLENGE_DATA,
    UPDATE_CHALLENGE_VALUE,
    SET_CHALLENGE_ERROR,
    UPDATE_CHALLENGE_TYPE
} from '../actions/challenge';
import {SET_CHALLENGE_3DS_URL, SET_3DS_LOADING_STATUS, SET_TRUST_FRAME_OPEN_STATE} from '@blocks/UserValidate/actions';

export default function challenge(state = {}, action = {}) {
    switch (action.type) {
        case SET_CHALLENGE_DATA: {
            return Object.assign({}, state, action.data);
        }
        case UPDATE_CHALLENGE_VALUE: {
            return Object.assign({}, state, {
                fieldValue: action.value,
                errorText: '',
                errorCode: ''
            });
        }
        case SET_CHALLENGE_ERROR: {
            const {text, code} = action.error;

            return Object.assign({}, state, {
                errorText: text,
                errorCode: code
            });
        }
        case UPDATE_CHALLENGE_TYPE: {
            return Object.assign({}, state, {
                alternative: {
                    challengeType: state.challengeType,
                    hint: state.hint
                },
                challengeType: action.newChallenge.type,
                hint: action.newChallenge.hint
            });
        }
        case SET_CHALLENGE_3DS_URL: {
            return Object.assign({}, state, {
                url3ds: action.payload
            });
        }
        case SET_3DS_LOADING_STATUS: {
            return Object.assign({}, state, {
                is3dsLoading: action.payload
            });
        }
        case SET_TRUST_FRAME_OPEN_STATE: {
            return Object.assign({}, state, {
                isTrustFrameOpened: action.payload
            });
        }
        default:
            return state;
    }
}
