import {
    SET_CHANGE_PASSWORD_DATA,
    SET_CHANGE_PASSWORD_PHONE_STATUS,
    SET_CHANGE_PASSWORD_STEP,
    SET_CHANGE_PASSWORD_QUESTION,
    SET_PHONE_NUMBER_UPDATED,
    SET_CHANGE_PASSWORD_PHONE_WARNING,
    SET_SMS_2FA_UPDATED
} from '../actions/forcePasswordChange';

export default function changePassword(state = {}, action) {
    switch (action.type) {
        case SET_CHANGE_PASSWORD_DATA: {
            return Object.assign({}, state, action.payload);
        }

        case SET_CHANGE_PASSWORD_STEP: {
            return Object.assign({}, state, {
                step: action.payload
            });
        }

        case SET_CHANGE_PASSWORD_PHONE_STATUS: {
            return Object.assign({}, state, {
                status: action.payload
            });
        }

        case SET_CHANGE_PASSWORD_QUESTION: {
            return Object.assign({}, state, {
                question: action.payload
            });
        }

        case SET_PHONE_NUMBER_UPDATED: {
            return Object.assign({}, state, {
                isPhoneNumberUpdated: action.payload
            });
        }

        case SET_CHANGE_PASSWORD_PHONE_WARNING: {
            return Object.assign({}, state, {
                isPhoneOperationConflict: action.payload
            });
        }

        case SET_SMS_2FA_UPDATED: {
            return Object.assign({}, state, {
                hasSms2faUpdated: true
            });
        }

        default:
            return state;
    }
}
