import {
    SET_PROCESSED_ACCOUNT_UID,
    TOGGLE_CONTEXT_MENU_VISIBILITY,
    SET_CONTEXT_MENU_ANCHOR,
    SET_CONTEXT_MENU_TYPE,
    CLEAR_CONTEXT_MENU_STATE
} from '../actions';

const initialState = {
    uid: '',
    visible: false,
    anchor: undefined,
    type: 'logout'
};

export const contextMenu = (state = initialState, action) => {
    const {type, payload} = action;

    switch (type) {
        case SET_PROCESSED_ACCOUNT_UID: {
            return Object.assign({}, state, {
                uid: action.processedAccountUid
            });
        }

        case TOGGLE_CONTEXT_MENU_VISIBILITY: {
            return Object.assign({}, state, {
                visible: payload
            });
        }

        case SET_CONTEXT_MENU_ANCHOR: {
            return Object.assign({}, state, {
                anchor: payload
            });
        }

        case SET_CONTEXT_MENU_TYPE: {
            return Object.assign({}, state, {
                type: payload
            });
        }

        case CLEAR_CONTEXT_MENU_STATE: {
            // якорь и тип нельзя затирать, иначе попап сместится до того как закроется
            return Object.assign({}, state, {
                uid: '',
                visible: false
            });
        }

        default:
            return state;
    }
};
