import {
    AUTH_MAIL_SENT,
    AUTH_MAIL_CONFIRMED,
    AUTH_MAIL_CANCELLED,
    TOGGLE_MAIL_SENT_TOOLTIP,
    SET_AUTH_MAIL_ERROR,
    UPDATE_LOGIN_VALUE,
    SET_AUTH_MAIL_UPDATED,
    SET_AUTH_MAIL_DISABLED,
    SET_AUTH_MAIL_ENABLED
} from '../actions';

export default function mailAuth(state = {}, action) {
    switch (action.type) {
        case AUTH_MAIL_SENT: {
            return Object.assign({}, state, {
                isAuthMailSent: true,
                code: action.code
            });
        }
        case AUTH_MAIL_CONFIRMED: {
            return Object.assign({}, state, {
                isAuthConfirmed: true,
                retpath: action.retpath
            });
        }
        case AUTH_MAIL_CANCELLED: {
            return Object.assign({}, state, {
                isAuthCancelled: action.status
            });
        }
        case TOGGLE_MAIL_SENT_TOOLTIP: {
            return Object.assign({}, state, {
                isAuthMailConfirmationVisible: action.isVisible
            });
        }
        case SET_AUTH_MAIL_ERROR: {
            return Object.assign({}, state, {
                mailAuthError: action.error
            });
        }
        case UPDATE_LOGIN_VALUE: {
            return Object.assign({}, state, {
                isAuthMailSent: false,
                isAuthConfirmed: false,
                isAuthCancelled: false,
                isAuthMailConfirmationVisible: false,
                mailAuthError: '',
                isUpdatedAuthLetterStatus: false
            });
        }
        case SET_AUTH_MAIL_UPDATED: {
            return Object.assign({}, state, {
                isUpdatedAuthLetterStatus: action.isUpdated
            });
        }
        case SET_AUTH_MAIL_DISABLED: {
            return Object.assign({}, state, {
                isEnabled: false
            });
        }
        case SET_AUTH_MAIL_ENABLED: {
            return Object.assign({}, state, {
                isEnabled: true
            });
        }
        default:
            return state;
    }
}
