import {AUTH_MESSENGER_SENT, SET_AUTH_MESSENGER_ERROR} from '../actions/messengerAuth';
import {AUTH_MAIL_CANCELLED, SET_AUTH_MAIL_ERROR} from '../actions';

export default function messengerAuth(state = {}, action) {
    switch (action.type) {
        case AUTH_MESSENGER_SENT: {
            return Object.assign({}, state, {
                isSent: true,
                code: action.code
            });
        }
        case SET_AUTH_MESSENGER_ERROR: {
            return Object.assign({}, state, {
                error: action.error
            });
        }
        case AUTH_MAIL_CANCELLED: {
            return Object.assign({}, state, {
                isCancelled: action.status
            });
        }
        case SET_AUTH_MAIL_ERROR: {
            return Object.assign({}, state, {
                error: action.error
            });
        }
        default:
            return state;
    }
}
