import {CHANGE_MOBILE_MENU_VISIBILITY, CHANGE_MOBILE_MENU_TYPE, SET_PROCESSED_ACCOUNT_UID} from '../actions';

export default function mobileMenu(state = {}, action) {
    switch (action.type) {
        case CHANGE_MOBILE_MENU_VISIBILITY: {
            return Object.assign({}, state, {
                isShowMobileMenu: action.visible,
                mobileMenuType: action.visible ? state.mobileMenuType : null
            });
        }
        case CHANGE_MOBILE_MENU_TYPE: {
            return Object.assign({}, state, {
                mobileMenuType: action.mobileMenuType
            });
        }
        case SET_PROCESSED_ACCOUNT_UID: {
            return Object.assign({}, state, {
                processedAccountUid: action.processedAccountUid
            });
        }
        default:
            return state;
    }
}
