import {CHANGE_PAGE_POPUP_VISIBILITY, CHANGE_PAGE_POPUP_TYPE} from '../actions';

const ROUTER_LOCATION_CHANGE = '@@router/LOCATION_CHANGE';

export default function pagePopup(state = {}, action) {
    switch (action.type) {
        case CHANGE_PAGE_POPUP_VISIBILITY: {
            return Object.assign({}, state, {
                isShowPagePopup: action.visible,
                pagePopupType: action.visible ? state.pagePopupType : null
            });
        }
        case CHANGE_PAGE_POPUP_TYPE: {
            return Object.assign({}, state, {
                pagePopupType: action.pagePopupType
            });
        }
        case ROUTER_LOCATION_CHANGE: {
            return Object.assign({}, state, {
                isShowPagePopup: false,
                pagePopupType: null
            });
        }
        default:
            return state;
    }
}
