import {
    LITE_REGISTER_SET_TRACK_ID,
    LITE_REGISTER_CHANGE_FIRST_NAME,
    LITE_REGISTER_CHANGE_LAST_NAME,
    LITE_REGISTER_CHANGE_CONFIRMATION_CODE,
    LITE_REGISTER_SET_ERRORS,
    LITE_REGISTER_CHANGE_PASSWORD,
    LITE_REGISTER_CHANGE_PASSWORD_CONFIRM,
    LITE_REGISTER_LOGIN_REQUIRED,
    LITE_REGISTER_CHANGE_LOGIN,
    LITE_REGISTER_PASSWORD_WARNING,
    LITE_REGISTER_PASSWORD_ERROR_DESCR,
    LITE_REGISTER_SET_PASSWORD_VALID
} from '../actions/registerLite';

const initialState = {
    track_id: '',
    login: '',
    firstname: '',
    lastname: '',
    password: '',
    confirmationCode: '',
    errors: {},
    passwordWarning: '',
    passwordErrorDescription: '',
    isLoginRequired: false,
    isPasswordValid: false
};

export default function registerLite(state = initialState, action) {
    switch (action.type) {
        case LITE_REGISTER_SET_TRACK_ID: {
            return Object.assign({}, initialState, {
                track_id: action.track_id
            });
        }
        case LITE_REGISTER_CHANGE_FIRST_NAME: {
            return Object.assign({}, state, {
                firstname: action.firstname
            });
        }
        case LITE_REGISTER_CHANGE_LAST_NAME: {
            return Object.assign({}, state, {
                lastname: action.lastname
            });
        }
        case LITE_REGISTER_CHANGE_CONFIRMATION_CODE: {
            return Object.assign({}, state, {
                confirmationCode: action.confirmationCode
            });
        }
        case LITE_REGISTER_CHANGE_PASSWORD: {
            return Object.assign({}, state, {
                password: action.password
            });
        }
        case LITE_REGISTER_CHANGE_PASSWORD_CONFIRM: {
            return Object.assign({}, state, {
                passwordConfirm: action.passwordConfirm
            });
        }
        case LITE_REGISTER_CHANGE_LOGIN: {
            return Object.assign({}, state, {
                login: action.login
            });
        }
        case LITE_REGISTER_SET_ERRORS: {
            return Object.assign({}, state, {
                errors: action.errors
            });
        }
        case LITE_REGISTER_LOGIN_REQUIRED: {
            return Object.assign({}, state, {
                isLoginRequired: true
            });
        }
        case LITE_REGISTER_PASSWORD_WARNING: {
            return Object.assign({}, state, {
                passwordWarning: action.warning
            });
        }
        case LITE_REGISTER_PASSWORD_ERROR_DESCR: {
            return Object.assign({}, state, {
                passwordErrorDescription: action.text
            });
        }
        case LITE_REGISTER_SET_PASSWORD_VALID: {
            return Object.assign({}, state, {
                isPasswordValid: action.isValid
            });
        }
        default:
            return state;
    }
}
