import {
    CHANGE_PHONE,
    SET_SUGGESTED_ACCOUNTS,
    CHANGE_CHECK_PHONE_STATUS,
    SET_ERRORS,
    CLEAR_ERRORS,
    CHANGE_LAST_NAME,
    CHANGE_FIRST_NAME,
    CHANGE_CONFIRMATION_CODE,
    SWITCH_CONFIRM_METHOD,
    CHANGE_PHONE_VALIDATION_STATUS,
    CHANGE_PHONE_OVERHEAT_STATUS,
    UPDATE_PHONE_CONFIRMATION_CALL_NUMBER
} from '../actions/restoreLogin';
import {SWITCH_TO_MODE_RESTORE_LOGIN} from '../actions';

const initialState = {
    phone: '',
    firstName: '',
    lastName: '',
    confirmationCode: '',
    isPhoneCheckSent: false,
    callingNumberTemplate: '+7 901 XXX-ХХ-ХХ',
    accounts: [],
    errors: {},
    confirmMethod: 'by_sms',
    isCallExp: false,
    isFlashCallExp: false,
    isValidPhone: false,
    isPhoneOverheated: false
};

export default function restoreLogin(state = initialState, action) {
    switch (action.type) {
        case SWITCH_TO_MODE_RESTORE_LOGIN: {
            let confirmMethod = 'by_sms';

            if (state.isCallExp || state.isFlashCallExp) {
                confirmMethod = 'by_call';
            }

            return Object.assign({}, initialState, {
                confirmMethod,
                isCallExp: state.isCallExp,
                isFlashCallExp: false
            });
        }
        case CHANGE_PHONE: {
            return Object.assign({}, state, {
                phone: action.phone,
                isValidPhone: false,
                isPhoneOverheated: false
            });
        }
        case CHANGE_PHONE_OVERHEAT_STATUS: {
            return Object.assign({}, state, {
                isPhoneOverheated: action.isPhoneOverheated
            });
        }
        case CHANGE_FIRST_NAME: {
            return Object.assign({}, state, {
                firstName: action.firstName
            });
        }
        case CHANGE_LAST_NAME: {
            return Object.assign({}, state, {
                lastName: action.lastName
            });
        }
        case CHANGE_CONFIRMATION_CODE: {
            return Object.assign({}, state, {
                confirmationCode: action.confirmationCode
            });
        }
        case SET_SUGGESTED_ACCOUNTS: {
            return Object.assign({}, state, {
                accounts: action.accounts
            });
        }
        case UPDATE_PHONE_CONFIRMATION_CALL_NUMBER: {
            return Object.assign({}, state, {
                callingNumberTemplate: action.callingNumberStr
            });
        }
        case CHANGE_CHECK_PHONE_STATUS: {
            return Object.assign({}, state, {
                isPhoneCheckSent: action.isPhoneCheckSent
            });
        }
        case SWITCH_CONFIRM_METHOD: {
            return Object.assign({}, state, {
                confirmMethod: action.confirmMethod
            });
        }
        case SET_ERRORS: {
            return Object.assign({}, state, {
                errors: action.errors
            });
        }
        case CLEAR_ERRORS: {
            return Object.assign({}, state, {
                errors: {}
            });
        }
        case CHANGE_PHONE_VALIDATION_STATUS: {
            return Object.assign({}, state, {
                isValidPhone: action.isValidPhone
            });
        }
        default:
            return state;
    }
}
