import {SET_QUESTIONS} from '../../common/actions';
import {
    RESTORE_PASSWORD_SET_INITIAL_DATA,
    RESTORE_PASSWORD_SET_METHODS,
    RESTORE_PASSWORD_UPDATE_SELECTED_METHOD,
    RESTORE_PASSWORD_UPDATE_ERROR,
    RESTORE_PASSWORD_UPDATE_PROCESS_STATE,
    RESTORE_PASSWORD_UPDATE_CAPTCHA_STATUS,
    RESTORE_PASSWORD_SET_PHONE_STATUS,
    RESTORE_UPDATE_HINT_DATA
} from '../actions/restorePassword';
import {DELETE_TRACK_ID} from '../../actions/tracks';

const initialState = {
    trackId: null,
    isCaptchaRepeatRequired: false,
    methods: [],
    selectedMethod: '',
    logins: [],
    errors: {},
    urls: {}
};

export default function restorePassword(state = initialState, action) {
    switch (action.type) {
        case RESTORE_PASSWORD_SET_INITIAL_DATA: {
            return Object.assign({}, state, {
                trackId: action.payload.trackId,
                logins: action.payload.logins,
                urls: action.payload.urls
            });
        }
        case RESTORE_PASSWORD_SET_METHODS: {
            return Object.assign({}, state, {
                methods: action.methods
            });
        }
        case RESTORE_PASSWORD_UPDATE_SELECTED_METHOD: {
            return Object.assign({}, state, {
                selectedMethod: action.method,
                methodInfo: action.methodInfo
            });
        }
        case RESTORE_PASSWORD_UPDATE_ERROR: {
            return Object.assign({}, state, {
                errors: action.error
            });
        }
        case RESTORE_PASSWORD_UPDATE_PROCESS_STATE: {
            const updatedProcessState = Object.assign({}, state.processState, action.processState);

            return Object.assign({}, state, {
                processState: updatedProcessState
            });
        }
        case RESTORE_PASSWORD_UPDATE_CAPTCHA_STATUS: {
            return Object.assign({}, state, {
                isCaptchaRepeatRequired: action.isRequired
            });
        }
        case RESTORE_PASSWORD_SET_PHONE_STATUS: {
            return Object.assign({}, state, {
                isPhoneValidForCall: action.isValidForCall,
                number: action.number
            });
        }
        case SET_QUESTIONS: {
            return Object.assign({}, state, {
                questionsList: action.questions
            });
        }
        case RESTORE_UPDATE_HINT_DATA: {
            return Object.assign({}, state, {
                bindHint: Object.assign({}, state.bindHint || {}, action.payload)
            });
        }
        case DELETE_TRACK_ID: {
            return Object.assign({}, state, {
                trackId: null
            });
        }
        default:
            return state;
    }
}
