import {
    INIT_SOCIAL_SUGGEST_PROCESS,
    SET_REGISTER_LITE_STATE,
    SET_REGISTER_SOCIAL_STATE,
    CHANGE_STATE,
    CLEAR_STATE,
    EDIT_FORM_STATE
} from '../actions/socialSuggest';

const initialState = {
    registerLiteState: {},
    registerSocialState: {},
    isChangeFIO: false
};

export const socialSuggest = (state = initialState, action) => {
    const {type, payload} = action;

    switch (type) {
        case INIT_SOCIAL_SUGGEST_PROCESS:
        case CHANGE_STATE: {
            return Object.assign({}, state, payload);
        }

        case SET_REGISTER_LITE_STATE: {
            return Object.assign({}, state, {registerLiteState: payload});
        }

        case SET_REGISTER_SOCIAL_STATE: {
            return Object.assign({}, state, {registerSocialState: payload});
        }

        case EDIT_FORM_STATE: {
            return Object.assign({}, state, {isChangeFIO: true});
        }

        case CLEAR_STATE: {
            return initialState;
        }

        default: {
            return state;
        }
    }
};
