import loadable from '@loadable/component';
import ListPage from './pages/ListPage/ListPage.jsx';
import AddAccountPage from './pages/AddAccountPage/AddAccountPage.jsx';
import WelcomePage from './pages/WelcomePage/WelcomePage.jsx';
import MagicPromoPage from './pages/MagicPromoPage/MagicPromoPage.jsx';
import PhoneConfirm from './pages/PhoneConfirm/PhoneConfirm.jsx';
import {LoadableFallback} from '@components/LoadableFallback';
import restorePasswordRoutes from './pages/RestorePassword/routes';
import {authChildRoutes} from './pages/child/routes';
import {
    ENTRY_RESTORE_ROUTE,
    ENTRY_REGISTER_ROUTE,
    ENTRY_RESTORE_NEOPHONISH_ROUTE
} from '@blocks/UserEntryFlow/processes';
import {
    REGISTER_LITE_PATH,
    REGISTER_LITE_PASSWORD_PATH,
    REGISTER_LITE_NAME_PATH,
    REGISTER_LITE_EULA_PATH
} from './pages/RegisterLite/paths';

const loadableOptions = {fallback: LoadableFallback()};
const PhoneRequestPage = loadable(
    () => import(/* webpackChunkName: "PhoneRequestPage" */ './pages/PhoneRequestPage/PhoneRequestPage.jsx'),
    loadableOptions
);
const EmailRequestPage = loadable(
    () => import(/* webpackChunkName: "EmailRequestPage" */ './pages/EmailRequestPage/EmailRequestPage.jsx'),
    loadableOptions
);
// registration-lite
const RegisterLiteEnterPasswordPage = loadable(
    () =>
        import(
            // eslint-disable-next-line
            /* webpackChunkName: "RegisterLitePasswordForm" */ './pages/RegisterLite/PasswordForm/RegisterLitePasswordForm.jsx'
        ),
    loadableOptions
);
const PreRegisterPage = loadable(
    () => import(/* webpackChunkName: "PreRegisterPage" */ './pages/PreRegisterPage/PreRegisterPage.jsx'),
    loadableOptions
);
const RegisterLiteEnterCode = loadable(
    () =>
        import(
            /* webpackChunkName: "RegisterLiteEnterCode" */ './pages/RegisterLite/EnterCode/RegisterLiteEnterCode.jsx'
        ),
    loadableOptions
);
const RegisterLiteEnterNamePage = loadable(
    () =>
        import(/* webpackChunkName: "RegisterLiteNameForm" */ './pages/RegisterLite/NameForm/RegisterLiteNameForm.jsx'),
    loadableOptions
);
const AvatarRequestPage = loadable(
    () => import(/* webpackChunkName: "AvatarRequestPage" */ './pages/AvatarRequestPage/AvatarRequestPage.jsx'),
    loadableOptions
);
const RegisterLiteEulaPage = loadable(
    () => import(/* webpackChunkName: "RegisterLiteEula" */ './pages/RegisterLite/EulaPage/Eula.jsx'),
    loadableOptions
);
const AuthRegComplete = loadable(
    async () => await import(/* webpackChunkName: "AuthRegComplete" */ '../AuthRegComplete'),
    loadableOptions
);
const AuthRegPreComplete = loadable(
    async () => await import(/* webpackChunkName: "AuthRegPreComplete" */ '../AuthRegPreComplete'),
    loadableOptions
);
const AuthVerifyPage = loadable(
    async () => await import(/* webpackChunkName: "AuthVerify" */ '../AuthVerify'),
    loadableOptions
);
// challenge
const Challenge = loadable(
    () => import(/* webpackChunkName: "Challenge" */ './pages/Challenge/Challenge.jsx'),
    loadableOptions
);
// magic letter
const AuthWithLetterPage = loadable(
    () => import(/* webpackChunkName: "AuthWithLetterPage" */ './pages/AuthWithLetterPage/AuthWithLetterPage.jsx'),
    loadableOptions
);
const UserEntryFlow = loadable(
    () => import(/* webpackChunkName: "UserEntryFlow" */ '@blocks/UserEntryFlow'),
    loadableOptions
);
const SignUp = loadable(() => import(/* webpackChunkName: "SignUp" */ '@blocks/SignUp'), loadableOptions);

const changePasswordPage = loadable(
    () => import(/* webpackChunkName: "ChangePassword" */ './pages/ChangePassword'),
    loadableOptions
);

const socialSuggestPage = loadable(
    () => import(/* webpackChunkName: "SocialSuggest" */ './pages/SocialSuggest'),
    loadableOptions
);

const amDebugPage = loadable(() => import(/* webpackChunkName: "AmDebug" */ './pages/AmDebug'), loadableOptions);

const amFinishPage = loadable(() => import(/* webpackChunkName: "AmFinish" */ './pages/AmFinish'), loadableOptions);

export default function getRoutes(conditions = {}) {
    const mainRoutes = [
        {
            path: '/auth',
            exact: true,
            component: AddAccountPage
        },
        {
            path: '/auth/list',
            exact: true,
            component: ListPage
        },
        {
            path: '/auth/add',
            exact: true,
            component: AddAccountPage
        },
        {
            path: '/auth/magic',
            exact: true,
            component: MagicPromoPage
        },
        {
            path: '/auth/verify',
            exact: true,
            component: AuthVerifyPage
        },
        {
            path: '/auth/welcome',
            exact: true,
            component: WelcomePage
        },
        {
            path: '/auth/link',
            exact: true,
            component: AuthWithLetterPage
        },
        {
            path: '/auth/preregister',
            exact: true,
            component: PreRegisterPage
        },
        {
            path: '/register/link',
            exact: true,
            component: AuthWithLetterPage
        },
        {
            path: '/auth/phone',
            exact: true,
            component: PhoneRequestPage
        },
        {
            path: '/auth/email',
            exact: true,
            component: EmailRequestPage
        },
        {
            path: '/auth/avatar',
            exact: true,
            component: AvatarRequestPage
        },
        {
            path: '/auth/challenge',
            exact: true,
            component: Challenge
        },
        {
            path: ENTRY_RESTORE_ROUTE,
            exact: true,
            component: UserEntryFlow
        },
        {
            path: ENTRY_RESTORE_NEOPHONISH_ROUTE,
            exact: true,
            component: UserEntryFlow
        },
        {
            path: REGISTER_LITE_PATH,
            exact: true,
            component: RegisterLiteEnterCode
        },
        {
            path: REGISTER_LITE_PASSWORD_PATH,
            exact: true,
            component: RegisterLiteEnterPasswordPage
        },
        {
            path: REGISTER_LITE_NAME_PATH,
            exact: true,
            component: RegisterLiteEnterNamePage
        },
        {
            path: REGISTER_LITE_EULA_PATH,
            exact: true,
            component: RegisterLiteEulaPage
        },
        {
            path: '/auth/phoneconfirm',
            exact: true,
            component: PhoneConfirm
        },
        {
            path: '/phoneconfirm',
            exact: true,
            component: PhoneConfirm
        },
        {
            path: ENTRY_REGISTER_ROUTE,
            exact: true,
            component: SignUp
        },
        {
            path: '/auth/precomplete',
            exact: true,
            component: AuthRegPreComplete
        },
        {
            path: '/auth/complete',
            exact: true,
            component: AuthRegComplete
        },
        {
            path: '/auth/changepassword',
            exact: true,
            component: changePasswordPage
        },
        {
            path: '/auth/social-suggest',
            exact: true,
            component: socialSuggestPage
        },
        {
            path: '/am/finish',
            exact: true,
            component: amFinishPage
        }
    ];

    if (conditions.isAmDebugPageEnabled) {
        mainRoutes.push({
            path: '/am/debug',
            exact: true,
            component: amDebugPage
        });
    }

    return [...mainRoutes, ...restorePasswordRoutes, ...authChildRoutes];
}
