export default function formatAccountListUrl(options) {
    const {embeddedAuthUrl: basicUrl, yu, retpath, uid, action, origin, login} = options;

    if (['logout', 'change_default'].indexOf(action) !== -1) {
        return (
            `${basicUrl}` +
            `&yu=${encodeURIComponent(yu)}` +
            `&action=${encodeURIComponent(action)}` +
            `&uid=${encodeURIComponent(uid)}` +
            `&retpath=${encodeURIComponent(retpath)}` +
            `&origin=${encodeURIComponent(origin)}`
        );
    }

    if (['switchTo'].indexOf(action) !== -1) {
        return (
            `/auth/welcome?uid=${encodeURIComponent(uid)}` +
            `&retpath=${encodeURIComponent(retpath)}` +
            `&origin=${encodeURIComponent(origin)}`
        );
    }

    if (['login'].indexOf(action) !== -1) {
        return (
            `/auth/add?login=${encodeURIComponent(login)}` +
            `&retpath=${encodeURIComponent(retpath)}` +
            `&origin=${encodeURIComponent(origin)}`
        );
    }

    if (['retpath'].indexOf(action) !== -1) {
        return `${retpath}`;
    }

    return '';
}
