export default function formatRegistrationUrl(baseUrl, login, phone, country) {
    const queryParamRegexp = /(&)?(login|phone_number|country)=\2/;

    return baseUrl
        .replace(queryParamRegexp, login && !phone ? `$1$2=${login}` : '')
        .replace(queryParamRegexp, phone ? `$1$2=${encodeURIComponent(phone)}` : '')
        .replace(queryParamRegexp, country ? `$1$2=${country}` : '');
}
