import api from '@blocks/api';
import {setLoadingStatus, setAvatarProcessingStatus, updateAvatarUrl, setAvatarError} from './';
import {updateHeaderAvatar} from '@blocks/morda/components/header/actions';
import handleError from '@blocks/avatar-displayname/utils/setErrors';
import sendMetrics from '@blocks/avatar-displayname/utils/sendMetrics';
import {sendMessage} from '@blocks/utils';

export default function deleteAvatar() {
    return (dispatch, getState) => {
        const {
            avatar: {track_id: trackId, default_300: defaultUrl},
            common: {csrf, retpath}
        } = getState();

        dispatch(setAvatarError(''));
        dispatch(setLoadingStatus(true));
        dispatch(setAvatarProcessingStatus(true));
        sendMetrics('Удалить аватар', 'avatar-displayname_delete_avatar');
        api.request('avatars/delete', {track_id: trackId, csrf_token: csrf})
            .done((response) => {
                if (response && response.status === 'ok') {
                    dispatch(
                        updateAvatarUrl({
                            url: defaultUrl
                        })
                    );
                    dispatch(updateHeaderAvatar());
                    sendMessage({deleteAvatar: 'success'}, retpath);
                } else {
                    dispatch(handleError('error-internal'));
                    sendMessage({deleteAvatar: 'error'}, retpath);
                }
            })
            .fail(() => {
                dispatch(handleError('error-internal'));
                sendMessage({deleteAvatar: 'error'}, retpath);
            })
            .always(() => {
                dispatch(setLoadingStatus(false));
                dispatch(setAvatarProcessingStatus(false));
            });
    };
}
