import api from '../../api';
import {setAvatarInitialTrackId} from './';
import handleError from '../utils/setErrors';

export default function getAvatarsTrack() {
    return (dispatch) => {
        api.request('avatars/init', {})
            .done((response = {}) => {
                const {
                    body: {track_id: trackId}
                } = response;

                if (trackId) {
                    dispatch(setAvatarInitialTrackId(trackId));
                } else {
                    dispatch(handleError('error-internal'));
                }
            })
            .fail((error) => {
                dispatch(handleError(error));
            });
    };
}
