import api from '../../api';
import {setInitialDisplayNameData} from './';
import {setPublicIdValue} from '@blocks/actions/publicId';
import metrics from '../../metrics';

export default function getDisplaynameData() {
    return (dispatch, getState) => {
        const {publicId: publicIdState = {}} = getState();

        api.request('profile/get-displayname')
            .then((response = {}) => {
                if (!response.displaynameInfo) {
                    return;
                }

                const {
                    displayName: {publicDisplayName}
                } = getState();
                const {displaynameInfo = {}, publicId, fullname} = response;
                const {displayNamesSuggest} = displaynameInfo;

                if (publicIdState.isEnabled && publicId) {
                    dispatch(setPublicIdValue(publicId));
                }

                dispatch(
                    setInitialDisplayNameData({
                        displayNamesList: displayNamesSuggest,
                        suggestedNames: Object.keys(displayNamesSuggest).filter((name) => name !== publicDisplayName),
                        fullname
                    })
                );
            })
            .fail(() => {
                metrics.send([
                    'Изменить персональные данные',
                    'Не удалось получить список для саджеста с дисплейнеймами'
                ]);
            });
    };
}
