import {avatarCropper} from '../utils/avatarCroper';
import metrics from '../../metrics';
import setDisplayName from '../actions/setDisplayName';

export default function handleUpdates() {
    return (dispatch, getState) => {
        const state = getState();
        const {
            avatar: {isProcessing: isAvatarProcessing}
        } = state;

        if (isAvatarProcessing) {
            dispatch(avatarCropper.cropAvatar(true));
            metrics.send(['Смена аватара', 'Сохранить отредактированный аватар']);
            metrics.goal('avatar-displayname_save_avatar');
        } else {
            dispatch(setDisplayName());
        }
    };
}
