export const PUBLIC_UPDATE_DISPLAYNAME = 'PUBLIC_UPDATE_DISPLAYNAME';
export const PUBLIC_UPDATE_DISPLAYNAME_UPDATE_PROCESSING_STATUS = 'PUBLIC_UPDATE_DISPLAYNAME_UPDATE_PROCESSING_STATUS';
export const PUBLIC_UPDATE_DISPLAYNAME_UPDATE_LOADING_STATUS = 'PUBLIC_UPDATE_DISPLAYNAME_UPDATE_LOADING_STATUS';
export const PUBLIC_UPDATE_DISPLAYNAME_ERROR = 'PUBLIC_UPDATE_DISPLAYNAME_ERROR';
export const PUBLIC_UPDATE_AVATAR_UPLOAD_METHOD = 'PUBLIC_UPDATE_AVATAR_UPLOAD_METHOD';
export const PUBLIC_UPDATE_DISPLAYNAME_SET_FROM_VARIANTS = 'PUBLIC_UPDATE_DISPLAYNAME_SET_FROM_VARIANTS';
export const PUBLIC_UPDATE_AVATAR_SET_TRACK = 'PUBLIC_UPDATE_AVATAR_SET_TRACK';
export const PUBLIC_UPDATE_AVATAR_ERROR = 'PUBLIC_UPDATE_AVATAR_ERROR';
export const PUBLIC_AVATAR_SET_PROCESSING_STATUS = 'PUBLIC_AVATAR_SET_PROCESSING_STATUS';
export const PUBLIC_AVATAR_UPDATE_URL = 'PUBLIC_AVATAR_UPDATE_URL';
export const PUBLIC_AVATAR_RESET_URL = 'PUBLIC_AVATAR_RESET_URL';
export const PUBLIC_AVATAR_UPDATE_IMAGE_OPTIONS = 'PUBLIC_AVATAR_UPDATE_IMAGE_OPTIONS';
export const PUBLIC_AVATAR_SET_LOADING_STATUS = 'PUBLIC_AVATAR_SET_LOADING_STATUS';
export const PUBLIC_UPDATE_DISPLAYNAME_UPDATE_SUGGESTED_NAMES = 'PUBLIC_UPDATE_DISPLAYNAME_UPDATE_SUGGESTED_NAMES';
export const PUBLIC_AVATAR_CHANGE_UPDATE_STATUS = 'PUBLIC_AVATAR_CHANGE_UPDATE_STATUS';
export const PUBLIC_UPDATE_DISPLAYNAME_SET_INITIAL_DATA = 'PUBLIC_UPDATE_DISPLAYNAME_SET_INITIAL_DATA';

export function setInitialDisplayNameData(data) {
    return {
        type: PUBLIC_UPDATE_DISPLAYNAME_SET_INITIAL_DATA,
        payload: data
    };
}

export function updateDisplayNameValue(value) {
    return {
        type: PUBLIC_UPDATE_DISPLAYNAME,
        value
    };
}

export function setDisplayNameProcessingStatus(isProcessing) {
    return {
        type: PUBLIC_UPDATE_DISPLAYNAME_UPDATE_PROCESSING_STATUS,
        isProcessing
    };
}

export function setDisplayNameLoadingStatus(isLoading) {
    return {
        type: PUBLIC_UPDATE_DISPLAYNAME_UPDATE_LOADING_STATUS,
        isLoading
    };
}

export function setDisplayNameError(error) {
    return {
        type: PUBLIC_UPDATE_DISPLAYNAME_ERROR,
        error
    };
}

export function setDisplayNameFromVariants(isFromVariants) {
    return {
        type: PUBLIC_UPDATE_DISPLAYNAME_SET_FROM_VARIANTS,
        isFromVariants
    };
}

export function updateSuggestedDisplaynames(namesList) {
    return {
        type: PUBLIC_UPDATE_DISPLAYNAME_UPDATE_SUGGESTED_NAMES,
        names: namesList
    };
}

export function setAvatarError(error) {
    return {
        type: PUBLIC_UPDATE_AVATAR_ERROR,
        error
    };
}

export function setAvatarProcessingStatus(isProcessing) {
    return {
        type: PUBLIC_AVATAR_SET_PROCESSING_STATUS,
        isProcessing
    };
}

export function setLoadingStatus(isLoading) {
    return {
        type: PUBLIC_AVATAR_SET_LOADING_STATUS,
        isLoading
    };
}

export function setAvatarInitialTrackId(trackId) {
    return {
        type: PUBLIC_UPDATE_AVATAR_SET_TRACK,
        trackId
    };
}

export function updateAvatarUrl(urlData) {
    return {
        type: PUBLIC_AVATAR_UPDATE_URL,
        urlData
    };
}

export function resetAvatarUrl(resetUrl) {
    return {
        type: PUBLIC_AVATAR_RESET_URL,
        resetUrl
    };
}

export function updateImageOptions(options) {
    return {
        type: PUBLIC_AVATAR_UPDATE_IMAGE_OPTIONS,
        options
    };
}

export function changeUpdateStatus(status) {
    return {
        type: PUBLIC_AVATAR_CHANGE_UPDATE_STATUS,
        isUpdated: status
    };
}
