import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import loadAvatarByFile from '@blocks/avatar-displayname/actions/loadAvatarByFile';
import {setAvatarError} from '../../actions';
import Error from '../Error/Error.jsx';

class SimpleForm extends Component {
    handleChangeFile = (event) => {
        const file = event.target.files[0];

        this.props.dispatch(loadAvatarByFile(file, true));
    };

    render() {
        const {csrf, trackId, avatarImage, error, isTouch, dispatch} = this.props;

        return (
            <form method='post' encType='multipart/form-data' id='load_avatar' action='/profile/avatars/legacy/'>
                <div>
                    <img width='270' height='270' src={avatarImage} alt='user avatar' id='user-avatar' />
                </div>
                <Error
                    isTouch={isTouch}
                    isVisible={Boolean(error)}
                    text={error}
                    dispatch={dispatch}
                    hideErrorAction={setAvatarError}
                />
                <div className='avatar-load block-item'>
                    <input type='hidden' name='csrf_token' value={csrf} />
                    <input type='hidden' name='track_id' value={trackId} />
                    <span>
                        <input type='file' name='file' onChange={this.handleChangeFile} />
                    </span>

                    <div className='avatar-size_description'>{i18n('_AUTH_.avatar.conditions')}</div>
                </div>
            </form>
        );
    }
}

export default connect(mapStateToProps)(SimpleForm);

SimpleForm.propTypes = {
    csrf: PropTypes.string.isRequired,
    trackId: PropTypes.string.isRequired,
    avatarImage: PropTypes.string.isRequired,
    error: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    isTouch: PropTypes.bool
};

function mapStateToProps(state) {
    const {
        common: {csrf},
        avatar: {avatarSize_300: avatarImage, track_id: trackId, error}
    } = state;

    return {
        csrf,
        trackId,
        avatarImage,
        error
    };
}
