import deleteAvatar from '../../actions/deleteAvatar';
import {avatarCropper} from '../../utils/avatarCroper';
import resetAvatar from '../../actions/resetAvatar';
import {setAvatarProcessingStatus} from '../../actions';
import metrics from '../../../metrics';

export default function mapDispatchToProps(dispatch) {
    return {
        deleteAvatar: () => dispatch(deleteAvatar()),
        cropAvatar: () => {
            dispatch(avatarCropper.cropAvatar());
            metrics.send(['Смена аватара', 'Сохранить отредактированный аватар']);
            metrics.goal('avatar-displayname_save_avatar');
        },
        cancelCrop: () => {
            dispatch(resetAvatar());
            avatarCropper.destroyCropper();
            dispatch(setAvatarProcessingStatus(false));
            metrics.send(['Смена аватара', 'Отменить загрузку']);
            metrics.goal('avatar-displayname_cancel_avatar');
        },
        dispatch
    };
}
