import React, {Component} from 'react';
import PropTypes from 'prop-types';

const CSS_PREFIX = 'passp-edit-avatar';

class Error extends Component {
    constructor(props) {
        super(props);

        this.hideError = this.hideError.bind(this);
    }

    hideError() {
        const {hideErrorAction, isTouch, dispatch} = this.props;

        if (isTouch) {
            return;
        }

        dispatch(hideErrorAction());
    }

    render() {
        const {isVisible, text} = this.props;

        if (isVisible) {
            return (
                <div className={`${CSS_PREFIX}_error`} data-t='error'>
                    {text}
                </div>
            );
        }

        return null;
    }
}

export default Error;

Error.propTypes = {
    isVisible: PropTypes.bool.isRequired,
    isTouch: PropTypes.bool.isRequired,
    text: PropTypes.string.isRequired,
    hideErrorAction: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired
};
