import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {cn} from '@bem-react/classname';
import {Checkbox} from '@components/Checkbox';
import {mapStateToProps} from './mapStateToProps';
import {mapDispatchToProps} from './mapDispatchToProps';

import './PersonalDataAllow.styl';

const b = cn('PersonalDataAllow');

class PersonalDataAllow extends PureComponent {
    handlePublicAccess = () => {
        const {hasPublicProfile, hasThirdPartyAccess} = this.props;

        this.props.toggleProfilePublicAccess();

        if (hasPublicProfile && hasThirdPartyAccess) {
            this.handleThirdPartyAccess();
        }
    };

    handleThirdPartyAccess = () => {
        this.props.toggleProfileThirdPartyAccess();
    };

    render() {
        const {isPublicAllowCheckbox, hasPublicProfile, hasThirdPartyAccess, error} = this.props;
        const isNotPublic = !hasPublicProfile && !hasThirdPartyAccess;

        if (isPublicAllowCheckbox) {
            return (
                <div className={b()}>
                    <div className={b('checkbox')}>
                        <div className={b('checkboxControl')}>
                            <Checkbox
                                id='p_access'
                                name='p_access'
                                checked={hasPublicProfile}
                                onChange={this.handlePublicAccess}
                                data-t='p_access:checkbox'
                            />
                        </div>

                        <label htmlFor='p_access' className={b('label')}>
                            {i18n('Profile2.publicAccess.publicLabel')}
                        </label>
                    </div>

                    <div className={b('checkbox')}>
                        <div className={b('checkboxControl')}>
                            <Checkbox
                                id='p_third_party_access'
                                name='p_third_party_access'
                                checked={hasThirdPartyAccess}
                                disabled={isNotPublic}
                                onChange={this.handleThirdPartyAccess}
                                data-t='p_third_party_access:checkbox'
                            />
                        </div>

                        <label htmlFor='p_third_party_access' className={b('label', {disabled: isNotPublic})}>
                            {i18n('Profile2.publicAccess.thirdPartyLabel')}
                        </label>
                    </div>
                    {error && (
                        <div className='passp-edit-avatar_error' data-t='error'>
                            {error}
                        </div>
                    )}
                </div>
            );
        }

        return null;
    }
}

const ConnectedPersonalDataAllow = connect(mapStateToProps, mapDispatchToProps)(PersonalDataAllow);

export {ConnectedPersonalDataAllow as PersonalDataAllow};

PersonalDataAllow.propTypes = {
    hasPublicProfile: PropTypes.bool,
    hasThirdPartyAccess: PropTypes.bool,
    isPublicAllowCheckbox: PropTypes.bool,
    toggleProfilePublicAccess: PropTypes.func.isRequired,
    toggleProfileThirdPartyAccess: PropTypes.func.isRequired,
    error: PropTypes.string
};
