import React, {PureComponent} from '@plibs/react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {cn} from '@bem-react/classname';
import {Modal} from '@plibs/pcomponents/Modal';
import {Button} from '@plibs/pcomponents/Button';
import './PersonalDataAllowPopup.styl';
import {mapStateToProps} from './mapStateToProps';
import {showPublicAccessPopup} from '@blocks/actions/publicAccess';

const b = cn('PersonalDataAllowPopup');

class PersonalDataAllowPopup extends PureComponent {
    closeModal = () => {
        this.props.dispatch(showPublicAccessPopup());
    };

    render() {
        const {isVisible, handlePublicAccess, closePersonalDataAllowPopup} = this.props;

        return (
            <Modal dataT='data-allow-popup' visible={isVisible} onCloserClick={this.closeModal}>
                <div className={b()}>
                    <h4 className={b('title')}>{i18n('Profile2.publicAccess.popupTitle')}</h4>
                    <p className={b('descr')}>{i18n('Profile2.publicAccess.popupText')}</p>

                    <div className={b('buttons')}>
                        <Button view='action' width='max' size='m' onClick={handlePublicAccess}>
                            {i18n('Profile2.publicAccess.allowBtn')}
                        </Button>
                        <Button view='pseudo' width='max' size='m' onClick={closePersonalDataAllowPopup}>
                            {i18n('Profile2.publicAccess.cancelBtn')}
                        </Button>
                    </div>
                </div>
            </Modal>
        );
    }
}

const ConnectedPersonalDataAllowPopup = connect(mapStateToProps)(PersonalDataAllowPopup);

export {ConnectedPersonalDataAllowPopup as PersonalDataAllowPopup};

PersonalDataAllowPopup.propTypes = {
    isVisible: PropTypes.bool.isRequired,
    handlePublicAccess: PropTypes.func.isRequired,
    closePersonalDataAllowPopup: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired
};
