import {
    PUBLIC_AVATAR_RESET_URL,
    PUBLIC_AVATAR_SET_PROCESSING_STATUS,
    PUBLIC_AVATAR_UPDATE_URL,
    PUBLIC_UPDATE_AVATAR_ERROR,
    PUBLIC_UPDATE_AVATAR_SET_TRACK,
    PUBLIC_UPDATE_AVATAR_UPLOAD_METHOD,
    PUBLIC_AVATAR_SET_LOADING_STATUS,
    PUBLIC_AVATAR_UPDATE_IMAGE_OPTIONS,
    PUBLIC_AVATAR_CHANGE_UPDATE_STATUS
} from '../actions';

const initialState = {
    track_id: null,
    default_300: '',
    avatarSize_300: '',
    avatarPrev: '',
    isProcessing: false,
    isLoading: false,
    fileType: 'jpeg',
    compression: 0.6,
    isCropNotSupported: false,
    error: '',
    isOptionalStep: true,
    isUpdated: false
};

export default function avatar(state = initialState, action) {
    switch (action.type) {
        case PUBLIC_UPDATE_AVATAR_UPLOAD_METHOD: {
            return Object.assign({}, state, {
                uploadMethod: action.method
            });
        }
        case PUBLIC_UPDATE_AVATAR_SET_TRACK: {
            return Object.assign({}, state, {
                track_id: action.trackId
            });
        }
        case PUBLIC_UPDATE_AVATAR_ERROR: {
            return Object.assign({}, state, {
                error: action.error
            });
        }
        case PUBLIC_AVATAR_SET_PROCESSING_STATUS: {
            return Object.assign({}, state, {
                isProcessing: action.isProcessing
            });
        }
        case PUBLIC_AVATAR_SET_LOADING_STATUS: {
            return Object.assign({}, state, {
                isLoading: action.isLoading
            });
        }
        case PUBLIC_AVATAR_UPDATE_URL: {
            return Object.assign({}, state, {
                avatarSize_300: action.urlData.url || state.avatarSize_300,
                avatarPrev: action.urlData.prevUrl || state.default_300
            });
        }
        case PUBLIC_AVATAR_RESET_URL: {
            return Object.assign({}, state, {
                avatarSize_300: action.resetUrl
            });
        }
        case PUBLIC_AVATAR_UPDATE_IMAGE_OPTIONS: {
            return Object.assign({}, state, {
                fileType: action.options.type,
                compression: action.options.compression
            });
        }
        case PUBLIC_AVATAR_CHANGE_UPDATE_STATUS: {
            return Object.assign({}, state, {
                isUpdated: action.isUpdated
            });
        }
        default:
            return state;
    }
}
