import {
    PUBLIC_UPDATE_DISPLAYNAME,
    PUBLIC_UPDATE_DISPLAYNAME_ERROR,
    PUBLIC_UPDATE_DISPLAYNAME_UPDATE_LOADING_STATUS,
    PUBLIC_UPDATE_DISPLAYNAME_UPDATE_PROCESSING_STATUS,
    PUBLIC_UPDATE_DISPLAYNAME_SET_FROM_VARIANTS,
    PUBLIC_UPDATE_DISPLAYNAME_UPDATE_SUGGESTED_NAMES,
    PUBLIC_UPDATE_DISPLAYNAME_SET_INITIAL_DATA
} from '../actions';

export default function displayName(state = {}, action) {
    switch (action.type) {
        case PUBLIC_UPDATE_DISPLAYNAME_SET_INITIAL_DATA: {
            return Object.assign({}, state, action.payload);
        }
        case PUBLIC_UPDATE_DISPLAYNAME: {
            return Object.assign({}, state, {
                value: action.value
            });
        }
        case PUBLIC_UPDATE_DISPLAYNAME_UPDATE_PROCESSING_STATUS: {
            return Object.assign({}, state, {
                isProcessing: action.isProcessing
            });
        }
        case PUBLIC_UPDATE_DISPLAYNAME_UPDATE_LOADING_STATUS: {
            return Object.assign({}, state, {
                isLoading: action.isLoading
            });
        }
        case PUBLIC_UPDATE_DISPLAYNAME_ERROR: {
            return Object.assign({}, state, {
                error: action.error
            });
        }
        case PUBLIC_UPDATE_DISPLAYNAME_SET_FROM_VARIANTS: {
            return Object.assign({}, state, {
                isFromVariants: action.isFromVariants
            });
        }
        case PUBLIC_UPDATE_DISPLAYNAME_UPDATE_SUGGESTED_NAMES: {
            return Object.assign({}, state, {
                filteredSuggestedNames: action.names
            });
        }
        default:
            return state;
    }
}
