import {FOUR_MB_IN_BYTES, ONE_MB_IN_BYTES} from '../avatarConsts';

export default function defineConvertOptions(originalFileType = 'jpeg', size) {
    const qualityParams = {
        type: originalFileType,
        compression: 0.6
    };
    const isLarge = size >= FOUR_MB_IN_BYTES;
    const isMedium = size < FOUR_MB_IN_BYTES && size >= ONE_MB_IN_BYTES;
    const isPNGorGIF = originalFileType === 'gif' || originalFileType === 'png';

    if (isPNGorGIF && isMedium) {
        qualityParams.type = 'jpeg';
    }

    if (isLarge) {
        qualityParams.type = 'jpeg';
        qualityParams.compression = 0.5;
    }

    return qualityParams;
}
