import {setAvatarError, setLoadingStatus, setAvatarProcessingStatus} from '../actions';
import processErrors from './processErrors';
import resetAvatar from '../actions/resetAvatar';
import {sendMessage} from '../../utils';

export default function setErrors(errorCode) {
    return (dispatch, getState) => {
        const state = getState();
        const {retpath} = state.common;

        sendMessage({updateAvatar: 'error'}, retpath);
        dispatch(setAvatarError(processErrors(errorCode)));
        dispatch(setLoadingStatus(false));
        dispatch(setAvatarProcessingStatus(false));
        dispatch(resetAvatar());
    };
}
