import './Avatar.styl';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import mapStateToProps from './mapStateToProps';
import {Spin} from '@components/Spin';
import {Button} from '@components/Button';
import {Attach} from '@components/Attach';
import {avatarCropper} from '@blocks/avatar-displayname/utils/avatarCroper';
import loadAvatarByFile from '@blocks/avatar-displayname/actions/loadAvatarByFile';
import {setAvatarProcessingStatus} from '@blocks/avatar-displayname/actions';
import resetAvatar from '@blocks/avatar-displayname/actions/resetAvatar';
import getAvatarsTrack from '@blocks/avatar-displayname/actions/getAvatarTrack';
import sendAvatarMetrics from '@blocks/avatar-registration/utils/sendAvatarMetrics';

import SimpleForm from './SimpleForm.jsx';

const CSS_CLASS = 'registration__avatar';

class Avatar extends Component {
    componentDidMount() {
        const {dispatch} = this.props;

        dispatch(getAvatarsTrack());
        sendAvatarMetrics('show', this.props.metricsInfo);
    }

    componentDidUpdate(prevProps) {
        const {resultRetpath, isUpdated} = this.props;

        if (!prevProps.isUpdated && isUpdated) {
            location.replace(resultRetpath);
        }
    }

    handleFile = (event) => {
        const targetElem = event.target || {};
        const file = targetElem.files && event.target.files[0];

        this.props.dispatch(loadAvatarByFile(file));
        sendAvatarMetrics('choose', this.props.metricsInfo);
    };

    clearFile = () => {
        const {dispatch} = this.props;

        dispatch(resetAvatar());
        avatarCropper.destroyCropper();
        dispatch(setAvatarProcessingStatus(false));
    };

    cropAvatar = () => {
        const {dispatch} = this.props;

        dispatch(avatarCropper.cropAvatar());
        sendAvatarMetrics('save', this.props.metricsInfo);
    };

    handleSkip = () => {
        const {onSkip, metricsInfo} = this.props;

        return onSkip ? onSkip() : sendAvatarMetrics('skip', metricsInfo);
    };

    onImgClick = () => {
        if (this.attachRef) {
            const control = this.attachRef.querySelector('#attach-control');

            control.click();
        }
    };

    setAttachRef = (ref) => (this.attachRef = ref);

    render() {
        const {
            isMobile,
            avatarUrl,
            isProcessing,
            isLoading,
            error,
            resultRetpath,
            skipDescription,
            isCropNotSupported
        } = this.props;
        const isMobileCancelShown = isMobile && isProcessing && !isLoading;

        if (isCropNotSupported) {
            return <SimpleForm />;
        }

        return (
            <div className={classnames(`${CSS_CLASS}-block`)}>
                <div className={`${CSS_CLASS}-image_wrap`}>
                    <img src={avatarUrl} alt='user avatar' className={`${CSS_CLASS}-image`} id='user-avatar' />
                    {!isProcessing && (
                        <>
                            <span className='add-avatar-bg' onClick={this.onImgClick} />
                            <span className='add-avatar-icon' />
                        </>
                    )}
                </div>
                {Boolean(error) && (
                    <div className={`${CSS_CLASS}-error`} role='alert'>
                        {error}
                    </div>
                )}
                {isMobileCancelShown && (
                    <span className='avatar-attach-mobile-cancel'>
                        <Button view='pseudo' size='s' type='button' onClick={this.clearFile}>
                            {i18n('_AUTH_.cancel.operation')}
                        </Button>
                    </span>
                )}
                {!skipDescription && <div className={`${CSS_CLASS}-descr`}>{i18n('_AUTH_.reg_avatar.descrExp1')}</div>}
                <div className={`${CSS_CLASS}-buttons`}>
                    <>
                        {isProcessing && (
                            <div className={`${CSS_CLASS}-save`}>
                                <Button view='action' size='l' width='max' onClick={this.cropAvatar}>
                                    {i18n('_AUTH_.reg_avatar.save')}
                                </Button>
                            </div>
                        )}
                        <div
                            className={classnames(`${CSS_CLASS}-attach`, {
                                'avatar-attach-hidden': isProcessing
                            })}
                        >
                            <Attach
                                view='action'
                                size='l'
                                disabled={false}
                                hasHolder={isProcessing}
                                width='max'
                                onClearClick={this.clearFile}
                                onChange={this.handleFile}
                                innerRef={this.setAttachRef}
                                id='attach-control'
                            >
                                {i18n('_AUTH_.reg_avatar.choose')}
                            </Attach>
                        </div>
                        <div className={`${CSS_CLASS}__spin`}>
                            <Spin size='s' progress={isLoading} />
                        </div>

                        <span className={`${CSS_CLASS}-btn`}>
                            <Button
                                view='pseudo'
                                size='l'
                                width='max'
                                onClick={this.handleSkip}
                                type='link'
                                url={resultRetpath}
                            >
                                {i18n('_AUTH_.reg_avatar.skip')}
                            </Button>
                        </span>
                    </>
                </div>
            </div>
        );
    }
}

export default connect(mapStateToProps)(Avatar);

Avatar.propTypes = {
    isMobile: PropTypes.bool.isRequired,
    isUpdated: PropTypes.bool,
    avatarUrl: PropTypes.string.isRequired,
    isProcessing: PropTypes.bool,
    isLoading: PropTypes.bool,
    error: PropTypes.string,
    resultRetpath: PropTypes.string,
    dispatch: PropTypes.func.isRequired,
    skipDescription: PropTypes.bool,
    metricsInfo: PropTypes.object,
    isCropNotSupported: PropTypes.bool,
    onSkip: PropTypes.func
};
