import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';

class SimpleForm extends Component {
    render() {
        const {csrf, trackId, avatarImage} = this.props;

        return (
            <form method='post' encType='multipart/form-data' id='load_avatar' action='/profile/avatars/legacy/'>
                <div>
                    <img width='270' height='270' src={avatarImage} alt='user avatar' id='user-avatar' />
                </div>
                <div className='avatar-load block-item'>
                    <input type='hidden' name='csrf_token' value={csrf} />
                    <input type='hidden' name='track_id' value={trackId} />
                    <span>
                        <input type='file' name='file' />
                    </span>

                    <div className='avatar-size_description'>{i18n('_AUTH_.avatar.conditions')}</div>
                </div>
                <div className='avatar-buttons'>
                    <div className='edit-avatar_btn-save'>
                        <Button view='action' size='l' width='max' type='submit'>
                            {i18n('_AUTH_.common.save')}
                        </Button>
                    </div>
                    <div className='edit-avatar_btn-cancel'>
                        <Button view='pseudo' size='l' type='link' url='/profile' width='max'>
                            {i18n('_AUTH_.common.cancel')}
                        </Button>
                    </div>
                </div>
            </form>
        );
    }
}

export default connect(mapStateToProps)(SimpleForm);

SimpleForm.propTypes = {
    csrf: PropTypes.string.isRequired,
    trackId: PropTypes.string.isRequired,
    avatarImage: PropTypes.string.isRequired
};

function mapStateToProps(state) {
    const {
        common: {csrf},
        avatar: {default_300: avatarImage, track_id: trackId}
    } = state;

    return {
        csrf,
        trackId,
        avatarImage
    };
}
