export default function mapStateToProps(state) {
    const {
        settings,
        common: {retpath, defaultPage, profile_url: profileUrl},
        avatar: {default_300, avatarSize_300, isProcessing, isLoading, error, isCropNotSupported, isUpdated}
    } = state;
    const avatarUrl = avatarSize_300 || default_300 || settings.avatar.default_300;
    const uatraits = settings.uatraits || settings.ua;
    const isMobile = Boolean(uatraits.isMobile && !uatraits.isTablet);
    const resultRetpath = retpath || defaultPage || profileUrl;

    return {
        isMobile,
        avatarUrl,
        isProcessing,
        isLoading,
        error,
        resultRetpath,
        isUpdated,
        isCropNotSupported
    };
}
