import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import Header from '@components/Header/Header.jsx';
import Promo from '@blocks/registration/desktop/promo/Promo.jsx';
import Avatar from '@blocks/avatar-registration/components/Avatar/Avatar.jsx';
import mapStateToProps from './mapStateToProps';

export class Page extends Component {
    render() {
        const {isMobile} = this.props;

        return (
            <div>
                <Header hideNavigation={true} />

                <div
                    className={classnames({
                        'main-container': !isMobile,
                        is_mobile_reg: isMobile,
                        'mobile_unified-experiment': isMobile
                    })}
                >
                    <Promo />
                    <main className={classnames('registration__wrapper', {registration__wrapper_desktop: !isMobile})}>
                        <div className='registration__avatar-wrapper'>
                            <h2 className='header__descr'>{i18n('Frontend.reg_avatar.title')}</h2>
                            <div className='registration__avatar'>
                                <Avatar />
                            </div>
                        </div>
                    </main>
                </div>
            </div>
        );
    }
}

export default connect(mapStateToProps)(Page);

Page.propTypes = {
    isMobile: PropTypes.bool,
    header: PropTypes.object,
    settings: PropTypes.object,
    common: PropTypes.object
};
