import passport from '@plibs/pclientjs/js/passport';
import broker from '@old-blocks/social/broker';
import {getSocialProfiles} from './morda/social_info/actions';
import {storageAvailable} from '@blocks/utils';

const REMOVE_ITEM_TIMEOUT = 2500;

let store;
const brokerWrapper = {
    init(s) {
        store = s;
        const state = store.getState();
        const social = state.social;
        const retpath = `${location.protocol}//${location.host}/profile`;
        const brokerpath = social.brokerPath;
        const tld = state.settings.tld;
        const brokerParams = {};
        const self = this;

        brokerParams.startUrl = brokerpath.replace('%tld%', tld);
        brokerParams.resize = 1;

        if (passport.isTouch) {
            brokerParams.display = 'touch';
            brokerParams.retnopopup = retpath;
        }

        if (window.addEventListener) {
            window.addEventListener('message', self.onSuccess);

            if (storageAvailable('localStorage')) {
                window.addEventListener('storage', function(e) {
                    if (e.isTrusted && e.key === 'socialResponse') {
                        const data = JSON.parse(window.localStorage.getItem('socialResponse'));

                        self.onSuccess({
                            origin: location.origin,
                            data
                        });

                        setTimeout(() => {
                            window.localStorage.removeItem('socialResponse');
                        }, REMOVE_ITEM_TIMEOUT);
                    }
                });
            }
        } else {
            window.attachEvent('onmessage', self.onSuccess);
        }

        window.socialResponse = function(data) {
            self.onSuccess({
                // eslint-disable-next-line compat/compat
                origin: location.origin,
                data
            });
        };

        broker.init(brokerParams);
    },

    onSuccess(message) {
        if (message.origin !== location.origin) {
            return;
        }

        if (message.data.socialAuth) {
            store.dispatch(getSocialProfiles());
        }
    },

    start(params) {
        broker.start(params);
    }
};

export default brokerWrapper;
