import {setQuestions} from './';
import api from '../../api';

function transformQuestions(questions) {
    return questions.map(function(question) {
        return {
            val: question.id,
            text: question.value
        };
    });
}

export default function getHintQuestions() {
    return (dispatch, getState) => {
        const {
            common: {track_id}
        } = getState();

        api.request('getQuestions', {track_id}).then((response) => {
            if (response && response.questions && response.questions.length) {
                dispatch(setQuestions(transformQuestions(response.questions)));
            }
        });
    };
}
