import {push, goBack} from 'react-router-redux';

export const SAVE_ACTION_FOR_REPEAT = 'SAVE_ACTION_FOR_REPEAT';
export const CONNECTION_ERROR = 'CONNECTION_ERROR';
export const SET_EDIT_MODE = 'SET_EDIT_MODE';
export const SHOW_REG_POPUP = 'SHOW_REG_POPUP';
export const CURRENT_PAGE_CHANGED = 'CURRENT_PAGE_CHANGED';
export const UPDATE_TRACK = 'UPDATE_TRACK';
export const GET_TRACK = 'GET_TRACK';
export const GET_TRACK_SUCCESS = 'GET_TRACK_SUCCESS';
export const GET_TRACK_FAIL = 'GET_TRACK_FAIL';
export const SETUP_BACK_PANE = 'SETUP_BACK_PANE';
export const LOCATION_CHANGE = 'LOCATION_CHANGE';
export const SETUP_PANE = 'SETUP_PANE';
export const GET_COUNTRIES = 'GET_COUNTRIES';
export const GET_TIMEZONES = 'GET_TIMEZONES';
export const TOGGLE_BACK_PANE_VISIBILITY = 'TOGGLE_BACK_PANE_VISIBILITY';
export const SET_QUESTIONS = 'SET_QUESTIONS';
export const SET_IS_AM = 'SET_IS_AM';
export const UPDATE_CSRF = 'UPDATE_CSRF';
export const UPDATE_RETPATH = 'UPDATE_RETPATH';

export function connectionError(error) {
    return {
        type: CONNECTION_ERROR,
        error
    };
}

export function saveActionForRepeat(actionToCall, ...payload) {
    return {
        type: SAVE_ACTION_FOR_REPEAT,
        actionToCall,
        payload
    };
}

export function setEditMode(edit) {
    return {
        type: SET_EDIT_MODE,
        edit
    };
}

export function showRegPopup(show) {
    return {
        type: SHOW_REG_POPUP,
        show
    };
}

export function goToRetpath() {
    return function(dispatch, getState) {
        const {retpath, defaultPage} = getState().common;

        if (retpath) {
            location.replace(retpath);
        } else {
            dispatch(push(defaultPage));
        }
    };
}

export function goToAuth() {
    return function(dispatch, getState) {
        const {defaultPage, authURL} = getState().common;

        if (authURL) {
            location.replace(authURL);
            return;
        }

        location.replace(`/auth?retpath=${defaultPage}`);
    };
}

export function changeCurrentPage(currentPage, historyEvent) {
    return {
        type: CURRENT_PAGE_CHANGED,
        currentPage,
        historyEvent
    };
}

export function updateTrack(trackId) {
    return {
        type: UPDATE_TRACK,
        track_id: trackId
    };
}

export function updateCSRF(token) {
    return {
        type: UPDATE_CSRF,
        token
    };
}

export function handleBack() {
    return function(dispatch, getState) {
        const state = getState();
        const common = state.common;

        if (typeof common.backPane === 'string') {
            dispatch(push(common.backPane));
        } else if (common.backPane) {
            dispatch(goBack());
        }

        dispatch(setupBackPane(null));
    };
}

export function setupBackPane(pane) {
    return function(dispatch) {
        dispatch({
            type: SETUP_BACK_PANE,
            pane
        });
    };
}

export function toggleBackPaneVisibility(isBackPaneVisible) {
    return function(dispatch) {
        dispatch({
            type: TOGGLE_BACK_PANE_VISIBILITY,
            isBackPaneVisible
        });
    };
}

export function setupPane(pane) {
    return function(dispatch) {
        dispatch({
            type: SETUP_PANE,
            pane
        });
    };
}

export function setQuestions(questions) {
    return {
        type: SET_QUESTIONS,
        questions
    };
}

export function updateRetpath(newRetpath) {
    return {
        type: UPDATE_RETPATH,
        payload: {
            newRetpath
        }
    };
}

export const setIsAM = (isAM) => (dispatch) =>
    dispatch({
        type: SET_IS_AM,
        payload: {isAM}
    });
