const LOCALES = {
    com: 'US',
    ru: 'RU',
    ua: 'UA',
    'com.tr': 'TR'
};
const supportedCache = {};

export function getLocale(lang = 'ru', tld = 'ru') {
    return `${lang}_${LOCALES[tld] || LOCALES.ru}`;
}

export function isCSSPropSupported(prop, {value, prefixed = true} = {}) {
    if (typeof document === 'undefined') {
        return true;
    }

    if (typeof prop !== 'string') {
        throw new Error('You can use only string to check if css prop supported');
    }

    if (supportedCache.hasOwnProperty(prop)) {
        return supportedCache[prop];
    }

    const props = [prop];
    const element = document.createElement('div');

    supportedCache[prop] = true;

    if (prop.indexOf('-') > 0) {
        props.push(prop.replace(/-([a-z])/g, (f) => f[1].toUpperCase()));
    }

    if (prefixed) {
        let last = props[props.length - 1];

        last = `${last.charAt(0).toUpperCase()}${last.slice(1)}`;

        ['Moz', 'webkit', 'Webkit', 'Khtml', 'O', 'ms'].forEach((prefix) => {
            props.push(`${prefix}${last}`);
        });
    }

    for (let i = 0; i < props.length; i++) {
        if (element.style[props[i]] !== undefined) {
            if (value) {
                element.style[props[i]] = value;
                return element.style[props[i]] === value;
            }

            return true;
        }
    }

    supportedCache[prop] = false;

    return false;
}
