import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {getCountDownStarted, getCountDownStopped} from './reducers';
import {countDownStart, countDownStop, countDownReset} from './actions';

class CountDown extends Component {
    constructor(props) {
        super(props);

        this.state = {
            countdown: 30
        };
    }

    static mapStateToProps(state) {
        return {
            start: getCountDownStarted(state),
            stop: getCountDownStopped(state)
        };
    }

    componentDidMount() {
        const {dispatch} = this.props;

        dispatch(countDownReset());
        dispatch(countDownStart());

        this.intervalId = setInterval(() => {
            const stopCountDown = () => {
                if (this.state.countdown === 0) {
                    clearInterval(this.intervalId);
                    dispatch(countDownStop());
                }
            };

            this.setState(
                (prevState) => ({
                    countdown: (prevState.countdown -= 1)
                }),
                stopCountDown()
            );
        }, 1000);
    }

    componentWillUnmount() {
        clearInterval(this.intervalId);
    }

    render() {
        const countdown = this.state.countdown;

        if (this.props.stop) {
            return null;
        }

        return <span className='send-code__countdown'>00:{countdown < 10 ? `0${countdown}` : countdown}</span>;
    }
}

export default connect(CountDown.mapStateToProps)(CountDown);

CountDown.propTypes = {
    start: PropTypes.bool,
    stop: PropTypes.bool,
    dispatch: PropTypes.func.isRequired
};
