import {COUNTDOWN_STARTED, COUNTDOWN_ENDED, COUNTDOWN_RESETED} from './actions';

const initialState = {
    start: false,
    stop: false
};

export default function(state = initialState, action) {
    switch (action.type) {
        case COUNTDOWN_STARTED: {
            return Object.assign({}, state, {
                start: true
            });
        }
        case COUNTDOWN_ENDED: {
            return Object.assign({}, state, {
                start: false,
                stop: true
            });
        }
        case COUNTDOWN_RESETED: {
            return Object.assign({}, state, {
                start: false,
                stop: false
            });
        }
        default:
            return state;
    }
}

export const getCountDownStarted = (state) => state.countDown.start;
export const getCountDownStopped = (state) => state.countDown.stop;
