import passport from '@plibs/pclientjs/js/passport';
import {UPDATE_TOKENS_SUCCESS} from '@blocks/auth/actions';
import {
    SAVE_ACTION_FOR_REPEAT,
    SHOW_REG_POPUP,
    SET_EDIT_MODE,
    CURRENT_PAGE_CHANGED,
    UPDATE_CSRF,
    SETUP_BACK_PANE,
    GET_TRACK_SUCCESS,
    UPDATE_TRACK,
    SETUP_PANE,
    GET_COUNTRIES,
    GET_TIMEZONES,
    TOGGLE_BACK_PANE_VISIBILITY,
    SET_IS_AM,
    UPDATE_RETPATH
} from './actions';

export default function(state = {}, action) {
    switch (action.type) {
        case SAVE_ACTION_FOR_REPEAT:
            return Object.assign({}, state, {
                actionForRepeat: {
                    action: action.actionToCall,
                    payload: action.payload
                }
            });
        case SET_EDIT_MODE:
            return Object.assign({}, state, {
                edit: action.edit
            });
        case SHOW_REG_POPUP:
            return Object.assign({}, state, {
                showRegPopup: action.show
            });
        case CURRENT_PAGE_CHANGED: {
            let historyOnPassport = state.historyOnPassport;

            switch (action.historyEvent) {
                case 'POP':
                    historyOnPassport -= 1;
                    break;
                case 'PUSH':
                    historyOnPassport += 1;
                    break;
                default:
                    break;
            }

            return Object.assign({}, state, {
                currentPage: action.currentPage,
                historyOnPassport
            });
        }
        case GET_TRACK_SUCCESS:
            passport.track_id = action.track_id;

            return Object.assign({}, state, {
                track_id: action.track_id
            });
        case UPDATE_TRACK: {
            return Object.assign({}, state, {
                track_id: action.track_id
            });
        }
        case UPDATE_CSRF:
            return Object.assign({}, state, {
                csrf: action.token
            });
        case SETUP_BACK_PANE:
            return Object.assign({}, state, {
                backPane: action.pane
            });
        case UPDATE_TOKENS_SUCCESS: {
            return Object.assign({}, state, {
                track_id: action.track_id,
                magic_csrf_token: action.csrf_token
            });
        }
        case SETUP_PANE: {
            return Object.assign({}, state, {
                pane: action.pane
            });
        }
        case TOGGLE_BACK_PANE_VISIBILITY: {
            return Object.assign({}, state, {
                isBackPaneVisible: action.isBackPaneVisible
            });
        }
        case GET_COUNTRIES: {
            return Object.assign({}, state, {
                countries: action.countries
            });
        }
        case GET_TIMEZONES: {
            return Object.assign({}, state, {
                timezones: action.timezones
            });
        }
        case SET_IS_AM: {
            return Object.assign({}, state, action.payload);
        }
        case UPDATE_RETPATH: {
            return Object.assign({}, state, {retpath: action.payload.newRetpath});
        }
        default:
            return state;
    }
}
