const SCROLL_DURATION = 500;
const hasRAF = typeof requestAnimationFrame !== 'undefined';

/* global jQuery */

/**
 * Animate element's property
 *
 * @param {Object} element       jQuery object to animate
 * @param {string} func          Element's property that should be animated (e.g. scrollTop)
 * @param {number} from          Initial position
 * @param {number} to            End position
 * @param {number} [duration]    Animation duration in ms
 * @return {undefined}
 */
export default function scrollTo({element, func, from, to, duration = SCROLL_DURATION}) {
    const _element = element instanceof jQuery ? element : $(element);
    const _from = from || _element[func]();
    const diff = to - _from;

    let prevTime = Date.now() - 1;

    let currentTime = 0;

    const animateScroll = () => {
        const now = Date.now();

        currentTime += now - prevTime;
        prevTime = now;
        _element[func](diff * (-Math.pow(2, (-10 * currentTime) / duration) + 1) + _from);
        if (currentTime < duration) {
            (hasRAF ? requestAnimationFrame : setTimeout)(animateScroll, hasRAF ? undefined : 20);
        }
    };

    animateScroll();
}
