import React from 'react';
import PropTypes from 'prop-types';

import {getStore} from './store.js';

const keys = ['mapState', 'children'];

export default class Store extends React.Component {
    constructor(props) {
        super(props);

        const store = getStore();

        this.state = {
            data: props.mapState(store.getState())
        };
        this._isMounted = false;
        this.unsubscribe = store.subscribe(() => {
            const data = props.mapState(store.getState());

            for (const key in data) {
                if (data.hasOwnProperty(key) && this.state.data[key] !== data[key]) {
                    if (this._isMounted) {
                        this.setState({data});
                    } else {
                        this.callOnMount = () => this.setState({data});
                    }
                    break;
                }
            }
        });
    }

    componentDidMount() {
        this._isMounted = true;

        if (this.callOnMount) {
            this.callOnMount();
            this.callOnMount = null;
        }
    }

    shouldComponentUpdate(props, state) {
        for (const key in props) {
            if (props.hasOwnProperty(key) && keys.indexOf(key) === -1 && this.props[key] !== props[key]) {
                return true;
            }
        }

        return this.state !== state;
    }

    componentWillUnmount() {
        if (this.unsubscribe) {
            this.unsubscribe();
        }
    }

    render() {
        return this.props.children(this.state.data);
    }
}

Store.propTypes = {
    mapState: PropTypes.func.isRequired,
    children: PropTypes.func.isRequired
};
