import React from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';

import * as extracted from './auth_type.js';

export default class AuthType extends React.Component {
    constructor(props) {
        super(props);

        this.sendMetrics = extracted.sendMetrics.bind(this);
    }

    shouldComponentUpdate() {
        return false;
    }

    render() {
        const {provider, displayName, authURL} = this.props;

        return (
            <div className='auth-type'>
                <div className='auth-type__content'>
                    <span className='auth-type__pre'>{i18n('Frontend.promo_complete_authed_as')}</span>
                    {provider ? <span className={`auth-type__icon social-icon_${provider}`} /> : ' '}
                    <span className='auth-type__name'>{displayName}</span>
                </div>
                <Link href={authURL} onClick={this.sendMetrics}>
                    {i18n('Frontend.promo_complete_choose')}
                </Link>
            </div>
        );
    }
}

AuthType.propTypes = {
    provider: PropTypes.string,
    displayName: PropTypes.string.isRequired,
    prefix: PropTypes.string.isRequired,
    authURL: PropTypes.string.isRequired
};
