import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';

import Form from './form.jsx';
import Promo from './promo.jsx';
import RegistrationHeader from '../registration/mobile/components/header.jsx';
import RegistrationTitle from '../registration/fieldComponents/RegistrationTitle.jsx';
import MobileFooter from '../registration/mobile/MobileFooter.jsx';

import AuthType from './auth_type.jsx';

import * as extracted from './complete.js';
import {TLD_TO_SKIP_PROMO} from '../registration/desktop/';

const titles = {
    complete_social: i18n('Frontend.promo_complete_title_swl'),
    complete_social_with_login: i18n('Frontend.promo_complete_title_default'),
    complete_lite: i18n('Frontend.promo_complete_title_lite'),
    force_complete_lite: i18n('Frontend.promo_complete_title_lite'),
    complete_autoregistered: i18n('Frontend.promo_complete_title_auto')
};

const descs = {
    complete_social: i18n('Frontend.promo_complete_desc_default'),
    complete_social_with_login: i18n('Frontend.promo_complete_desc_default'),
    complete_lite: i18n('Frontend.promo_complete_desc_lite'),
    force_complete_lite: i18n('Frontend.promo_complete_desc_lite'),
    complete_autoregistered: i18n('Frontend.promo_complete_desc_auto')
};

class Complete extends React.Component {
    static mapStateToProps(state) {
        const {
            common,
            settings = {},
            registrationErrors,
            registrationName,
            footer,
            fetchingStatus,
            form,
            person,
            captcha,
            logins
        } = state;
        const skipPromo = TLD_TO_SKIP_PROMO.includes(settings.tld);

        return {
            footer,
            common,
            settings,
            registrationErrors,
            registrationName,
            isFetching: fetchingStatus.isFetching,
            form,
            person,
            captcha,
            logins,
            skipPromo
        };
    }

    getChildContext() {
        return extracted.getChildContext.call(this);
    }

    render() {
        const {
            registrationErrors,
            registrationName,
            footer,
            settings,
            form,
            dispatch,
            isFetching,
            person,
            captcha,
            common,
            logins,
            skipPromo
        } = this.props;
        const {origin, isAppMode} = common;
        const {uatraits, language, isMobile} = settings;
        const servicesList = ['toloka', 'mail', 'disk', 'direct'];
        const title = titles[form.type];
        const description = descs[form.type];
        const hideDescription = origin === 'passport_profile';
        const isMobileCaptcha = Boolean(uatraits.isMobile || uatraits.isTablet);

        return (
            <div
                className={classnames({
                    'main-container': !isMobile,
                    'mobile_unified-experiment is_mobile_reg': isMobile
                })}
            >
                {!isMobile && !isAppMode && (
                    <Promo
                        hideDescription={hideDescription}
                        registrationErrors={registrationErrors}
                        langlist={footer.langlist}
                        tld={settings.tld}
                        env={settings.env}
                        help={settings.help}
                        language={language}
                        isFetching={isFetching}
                        provider={person.provider}
                        displayName={form.type !== 'complete_autoregistered' ? person.displayName : undefined}
                        prefix={form.prefix}
                        title={title}
                        description={description}
                        authURL={settings.authURL}
                        servicesList={servicesList}
                        skipPromo={skipPromo}
                    />
                )}
                <main
                    className={classnames('registration__wrapper complete', {
                        registration__wrapper_desktop: !isMobile && !skipPromo,
                        registration__wrapper_simple: skipPromo && !isMobile
                    })}
                >
                    <RegistrationHeader titleText={title} page='complete' skipPromo={skipPromo} />
                    <div
                        className={classnames({registration__block: !isMobile, 'registration__block-mobile': isMobile})}
                    >
                        <RegistrationTitle
                            skipPromo={skipPromo}
                            isMobile={isMobile}
                            title={i18n('Frontend.registration.complete.title')}
                        />
                        {skipPromo && !isMobile && (
                            <div className='auth-type__content-simple'>
                                <AuthType
                                    provider={person.provider}
                                    displayName={
                                        form.type !== 'complete_autoregistered' ? person.displayName : undefined
                                    }
                                    prefix={form.prefix}
                                    authURL={settings.authURL}
                                />
                            </div>
                        )}
                        <Form
                            dispatch={dispatch}
                            form={form}
                            person={person}
                            captcha={captcha}
                            lang={language}
                            isMobile={isMobile}
                            isMobileCaptcha={isMobileCaptcha}
                            registrationErrors={registrationErrors}
                            registrationName={registrationName}
                            isFetching={isFetching}
                            settings={settings}
                            logins={logins}
                        />
                    </div>
                </main>
                {!isAppMode && <MobileFooter isFetching={isFetching} isMobile={isMobile} />}
            </div>
        );
    }
}

Complete.propTypes = {
    registrationErrors: PropTypes.object,
    registrationName: PropTypes.string.isRequired,
    dispatch: PropTypes.func,
    footer: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    isFetching: PropTypes.bool,
    form: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    captcha: PropTypes.object.isRequired,
    common: PropTypes.object.isRequired,
    logins: PropTypes.object.isRequired,
    skipPromo: PropTypes.bool
};

Complete.childContextTypes = {
    prefix: PropTypes.string
};

export default connect(Complete.mapStateToProps)(Complete);
