import checkIfInvalid from '@blocks/registration/methods/checkIfInvalid';
import {updateValues, updateErrorsValid, updateStates, updateErrors} from '@blocks/actions/form';

/* eslint-disable no-invalid-this */

export function checkIfInvalidHandler() {
    this.props.dispatch(checkIfInvalid('password'));
}

export function updateAndCheck(event) {
    const {target = {}} = event;
    const {value} = target;
    const field = 'password';
    const {dispatch, state} = this.props;

    dispatch(updateValues({field, value}));

    if (!value && state === 'valid') {
        const error = {
            code: 'missingvalue',
            text: i18n('_AUTH_.password_current_errors_missingvalue')
        };

        dispatch(updateStates({field, status: 'not_valid'}));
        dispatch(updateErrors({field, error, errorDescription: '', active: true}));
    } else if (value && state !== 'valid') {
        dispatch(updateStates({field, status: 'valid'}));
        dispatch(updateErrorsValid(field));
    }
}

export function toggleFieldType() {
    this.setState((prev) => ({
        passwordHidden: !prev.passwordHidden
    }));
}
