import React from 'react';
import {Checkbox} from '@components/Checkbox';
import {Button} from '@components/Button';
import EulaPopup from '@blocks/registration/desktop/eula/EulaPopup.jsx';
import regMethods from '@blocks/registration/methods/basicRegistrationMethods';
import validateFormData from '@blocks/registration/methods/validateForm';
import {updateValues, updateErrorsValid, updateValidationMethod} from '@blocks/actions/form';
import {
    REGISTRATION_COMPLETE_GOAL_PREFIX,
    REGISTRATION_COMPLETE_MOBILE_GOAL_PREFIX
} from '@blocks/registration/actions';
import metrics from '@blocks/metrics';

/* eslint-disable no-invalid-this */

export function prepareData(type) {
    const {
        form: {
            values,
            states,
            type: state,
            captchaRequired,
            validation: {method}
        },
        person: {hasRecoveryMethod},
        isMobile
    } = this.props;
    const prepared =
        type === 'states' ? regMethods.prepareFormData(states, method, isMobile) : Object.assign({}, values);

    if (type === 'values') {
        prepared.state = state;

        if (state !== 'complete_lite') {
            prepared['human-confirmation'] = method;
        }
    }

    if (!captchaRequired && hasRecoveryMethod && prepared.hasOwnProperty('captcha')) {
        delete prepared.captcha;
    }

    if (isMobile && prepared.hasOwnProperty('password_confirm')) {
        delete prepared.password_confirm;
    }

    return prepared;
}

export function toggleValidationMethod() {
    const {form, dispatch} = this.props;
    const currentMethod = form.validation.method;

    dispatch(updateValidationMethod(currentMethod === 'phone' ? 'captcha' : 'phone'));

    metrics.send(['Подтверждение телефона', 'Регистрируйтесь без телефона']);
    metrics.goal(`${REGISTRATION_COMPLETE_MOBILE_GOAL_PREFIX}_phoneconfirm_switch_method`);
}

export function updateUserField(event) {
    const {target} = event;
    const {value, name} = target;
    const fieldInfo = {
        field: name,
        value
    };

    this.props.dispatch(updateValues(fieldInfo));
    this.props.dispatch(updateErrorsValid(name));
}

export function onFormSubmit(evt) {
    evt.preventDefault();

    metrics.send(['Форма', 'Попытка отправки']);
    metrics.goal(`${REGISTRATION_COMPLETE_GOAL_PREFIX}_form_submitted`);

    validateForm.call(this);
}

/* eslint-disable complexity */
/* eslint-disable guard-for-in */
export function validateForm() {
    if (!this.state.eulaChecked) {
        return;
    }

    this.props.dispatch(validateFormData());
}
/* eslint-enable complexity */
/* eslint-enable guard-for-in */

export function handleEula() {
    this.setState((prevState) => ({
        eulaChecked: !prevState.eulaChecked
    }));
}

export function eula(isShowingInPopup) {
    if (isShowingInPopup) {
        return null;
    }
    return (
        <div className='form__eula'>
            <Checkbox
                size='m'
                id='the-id2-theme-normal'
                name='the-name-theme-normal'
                checked={this.state.eulaChecked}
                onChange={this.handleEula}
                dangerouslyLabel={i18n('EULA.acceptance.register_2')}
            />
        </div>
    );
}

export function returnSubmitRegistrationFunction() {
    const {form, dispatch} = this.props;
    const method = form.validation.method;
    const formData = prepareData.call(this, 'values');

    if (method === 'captcha') {
        if (formData.hint_question_id === '99') {
            formData.hint_question = formData.hint_question_custom;
        }
    }

    if (typeof method !== 'undefined') {
        formData['human-confirmation'] = method;
    }

    dispatch(regMethods.submitRegistration(formData));
}

export function submit() {
    const {form, registrationName} = this.props;
    const {type} = form;
    const {phoneCodeStatus, phoneCode} = form.states;
    const phoneConfirmationInProcess = phoneCodeStatus === 'code_sent' && phoneCode !== 'valid';
    const isRegistrationWithEula = !['complete_social', 'complete_social_with_login'].includes(type);

    return (
        <div>
            <Button
                view='action'
                size='l'
                width='max'
                type='submit'
                disabled={!this.state.eulaChecked || this.props.isFetching || phoneConfirmationInProcess}
                onClick={this.onFormSubmit}
            >
                {registrationName === 'complete' ? i18n('_AUTH_.next') : i18n('Profile.regpromo.register')}
            </Button>
            {isRegistrationWithEula && (
                <EulaPopup text={i18n('EULA.acceptance.register_2')} sendData={this.returnSubmitRegistrationFunction} />
            )}
        </div>
    );
}

export function onTickerUnmount(secondsLeft) {
    this.setState({secondsLeft});

    this.timer = setInterval(() => {
        if (--secondsLeft <= 0) {
            // eslint-disable-line
            clearInterval(this.timer);
            this.timer = null;
        }

        this.setState({secondsLeft});
    }, 1000);
}
