import React from 'react';
import PropTypes from 'prop-types';

import UserPassword from '../registration/fieldComponents/userpassword.jsx';
import HumanConfirmation from '../registration/fieldComponents/human_confirmation/human_confirmation.jsx';
import RegistrationNameInput from '../registration/fieldComponents/name/name_input.jsx';
import RegistrationSurnameInput from '../registration/fieldComponents/surname/surname_input.jsx';
import RegistrationLoginInput from '../registration/fieldComponents/login/login_input.jsx';
import ControlCaptcha from '../registration/fieldComponents/human_confirmation/hint_question/control_captcha.jsx';

import CurrentPassword from './current_password.jsx';

import * as extracted from './form.js';

export default class Form extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            eulaChecked: true,
            secondsLeft: 0
        };
        this.onFormSubmit = extracted.onFormSubmit.bind(this);
        this.handleEula = extracted.handleEula.bind(this); // don't touch this!
        this.updateUserField = extracted.updateUserField.bind(this);
        this.toggleValidationMethod = extracted.toggleValidationMethod.bind(this);
        this.onTickerUnmount = extracted.onTickerUnmount.bind(this);
        this.returnSubmitRegistrationFunction = extracted.returnSubmitRegistrationFunction.bind(this);
        this.isLoading = true;
    }

    componentDidMount() {
        this.isLoading = false;
        this.forceUpdate();
    }

    render() {
        const {form, dispatch, person, isMobile, isMobileCaptcha, lang, captcha, registrationErrors} = this.props;
        const {activeField, validation, states, values, errors, type} = form;
        const {isLiteWithoutPassword} = person;
        const isNormalPasswordInputShown =
            (type !== 'complete_lite' || isLiteWithoutPassword) && type !== 'force_complete_lite';

        return (
            <form
                className={`registration__form registration__form_${isMobile ? 'mobile' : 'desktop'}`}
                autoComplete='off'
                method='post'
                action='/profile/complete/submit'
                onSubmit={this.onFormSubmit}
            >
                {type !== 'complete_autoregistered' && type !== 'complete_neophonish' && (
                    <RegistrationNameInput
                        dispatch={dispatch}
                        value={values.firstname}
                        state={states.firstname}
                        activeError={errors.active}
                        activeField={activeField}
                        error={errors.firstname}
                        updateUserField={this.updateUserField}
                    />
                )}
                {type !== 'complete_autoregistered' && type !== 'complete_neophonish' && (
                    <RegistrationSurnameInput
                        dispatch={dispatch}
                        value={values.lastname}
                        state={states.lastname}
                        error={errors.lastname}
                        hintActive={errors.hintActive}
                        activeField={activeField}
                        updateUserField={this.updateUserField}
                    />
                )}
                {type !== 'complete_social' && type !== 'complete_autoregistered' && (
                    <RegistrationLoginInput isAutoComplete={false} updateUserField={this.updateUserField} />
                )}

                {isNormalPasswordInputShown && (
                    <UserPassword
                        isMobile={isMobile}
                        states={states}
                        values={values}
                        errors={errors}
                        dispatch={dispatch}
                    />
                )}

                {type === 'complete_lite' && type !== 'complete_neophonish' && !isLiteWithoutPassword && (
                    <CurrentPassword
                        value={values.password}
                        error={errors.password}
                        state={states.password}
                        active={errors.active === 'password'}
                        isAutoComplete={false}
                        dispatch={dispatch}
                        isMobile={isMobile}
                    />
                )}
                {(!person.hasRecoveryMethod ||
                    (type !== 'complete_lite' && type !== 'force_complete_lite' && type !== 'complete_neophonish')) && (
                    <HumanConfirmation />
                )}
                {form.captchaRequired && validation.method !== 'captcha' && (
                    <ControlCaptcha
                        fieldCaptcha={values.captcha}
                        stateError={states.captcha}
                        textError={(errors.captcha || {}).text}
                        activeError={errors.active}
                        onInputChange={this.updateUserField}
                        isMobileCaptcha={isMobileCaptcha}
                        lang={lang}
                        captcha={captcha}
                        captchaErrors={[]}
                        dispatch={dispatch}
                    />
                )}
                <div className='form__submit'>{extracted.submit.call(this)}</div>
                {(registrationErrors.status === 'global' ||
                    (registrationErrors.status === 'error' && registrationErrors.code === 'global')) && (
                    <p className='error'>{registrationErrors.text}</p>
                )}
            </form>
        );
    }
}

Form.propTypes = {
    dispatch: PropTypes.func.isRequired,
    form: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    captcha: PropTypes.object.isRequired,
    isMobile: PropTypes.bool,
    isMobileCaptcha: PropTypes.bool,
    lang: PropTypes.string.isRequired,
    isFetching: PropTypes.bool.isRequired,
    registrationErrors: PropTypes.object.isRequired,
    registrationName: PropTypes.string.isRequired,
    settings: PropTypes.object.isRequired,
    logins: PropTypes.object.isRequired
};
