import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import NameField from '../registration/mobile/components/name_field.jsx';
import SurnameField from '../registration/mobile/components/surname_field.jsx';
import SpinnerComponent from '../registration/spinner/spinner.jsx';
import PasswordField from '../registration/mobile/components/password_field.jsx';
import PhoneNumberField from '../registration/mobile/components/phone_number_field.jsx';
import PhoneConfirmationField from '../registration/mobile/components/phone_confirmation_field.jsx';
import LoginField from '../registration/mobile/components/login_field.jsx';
import SecurityQuestionField from '../registration/mobile/components/security_question_field.jsx';
import SecurityAnswerField from '../registration/mobile/components/security_answer_field.jsx';
import CaptchaField from '../registration/mobile/components/captcha_field.jsx';
import ToggleValidationMethodBtn from '../registration/mobile/components/toggle_validation_method_btn.jsx';

import CurrentPassword from './current_password.jsx';
import * as extracted from './form';

export default class FormMobile extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            eulaChecked: true,
            secondsLeft: 0
        };
        this.onFormSubmit = extracted.onFormSubmit.bind(this);
        this.handleEula = extracted.handleEula.bind(this); // don't touch this!
        this.updateUserField = extracted.updateUserField.bind(this);
        this.toggleValidationMethod = extracted.toggleValidationMethod.bind(this);
        this.onTickerUnmount = extracted.onTickerUnmount.bind(this);
        this.returnSubmitRegistrationFunction = extracted.returnSubmitRegistrationFunction.bind(this);
        this.isLoading = true;
    }

    componentDidMount() {
        this.isLoading = false;
        this.forceUpdate();
    }

    render() {
        const {form, dispatch, person, isMobile, captcha, isFetching, registrationErrors, settings} = this.props;
        const {humanConfirmation, validation, states, values, errors, type, confirmationRetryCountdown} = form;
        const activeError = errors.active;
        const fetchingStatus = {isFetching: this.isLoading};

        return (
            <form
                className='registration__form registration__form_mobile'
                autoComplete='off'
                method='post'
                action='/profile/complete/submit'
                onSubmit={this.onFormSubmit}
            >
                {type !== 'complete_autoregistered' && (
                    <NameField
                        fieldState={states.firstname}
                        fieldValue={values.firstname}
                        fieldError={errors.firstname}
                        activeError={activeError}
                        dispatch={dispatch}
                    />
                )}

                {type !== 'complete_autoregistered' && (
                    <SurnameField
                        fieldState={states.lastname}
                        fieldValue={values.lastname}
                        fieldError={errors.lastname}
                        activeError={activeError}
                        dispatch={dispatch}
                    />
                )}
                {type !== 'complete_social' && type !== 'complete_autoregistered' && (
                    <LoginField
                        registrationStep={-1}
                        fieldState={states.login}
                        fieldValue={values.login}
                        fieldError={errors.login}
                        firstname={values.firstname}
                        lastname={values.lastname}
                        activeError={errors.active}
                        logins={this.props.logins}
                        dispatch={dispatch}
                    />
                )}
                {type !== 'complete_lite' && type !== 'force_complete_lite' && (
                    <PasswordField
                        registrationStep={-1}
                        fieldState={states.password}
                        fieldValue={values.password}
                        fieldError={errors.password}
                        login={values.login || ''}
                        activeError={errors.active}
                        dispatch={dispatch}
                    />
                )}
                {type === 'complete_lite' && (
                    <CurrentPassword
                        value={values.password}
                        error={errors.password}
                        state={states.password}
                        active={errors.active === 'password'}
                        dispatch={dispatch}
                        isMobile={isMobile}
                    />
                )}
                {(!person.hasRecoveryMethod || (type !== 'complete_lite' && type !== 'force_complete_lite')) &&
                    (() => {
                        if (typeof $ !== 'undefined') {
                            return (
                                <div>
                                    <div
                                        className={classnames('phone__confirm-wrapper', {
                                            'confirm__fields-active': validation.method === 'phone'
                                        })}
                                    >
                                        <PhoneNumberField
                                            fieldState={states.phone}
                                            fieldValue={values.phone}
                                            fieldError={errors.phone}
                                            activeError={activeError}
                                            phoneCodeState={states.phoneCode}
                                            phoneCodeStatusState={states.phoneCodeStatus}
                                            dispatch={dispatch}
                                        />

                                        <PhoneConfirmationField
                                            fieldState={states.phoneCode}
                                            fieldValue={values.phoneCode}
                                            fieldError={errors.phoneCode}
                                            isFetching={humanConfirmation.isFetching}
                                            validationMethod={validation.method}
                                            phone={values.phone}
                                            phoneError={errors.phone}
                                            phoneCodeStatusState={states.phoneCodeStatus}
                                            password={type !== 'complete_lite' ? values.password : undefined}
                                            activeError={activeError}
                                            onTickerUnmount={this.onTickerUnmount}
                                            secondsLeft={this.state.secondsLeft}
                                            confirmationRetryCountdown={confirmationRetryCountdown}
                                            dispatch={dispatch}
                                        />
                                    </div>
                                    <div
                                        className={classnames('security_question__confirm-wrapper', {
                                            'confirm__fields-active': validation.method !== 'phone'
                                        })}
                                    >
                                        <SecurityQuestionField
                                            questionList={humanConfirmation.questionList}
                                            hintQuestion={values.hint_question}
                                            hintQuestionId={values.hint_question_id}
                                            hintQuestionCustom={values.hint_question_custom}
                                            hintQuestionCustomState={states.hint_question_custom}
                                            hintQuestionCustomError={errors.hint_question_custom}
                                            activeError={activeError}
                                            dispatch={dispatch}
                                        />
                                        <SecurityAnswerField
                                            fieldState={states.hint_answer}
                                            fieldValue={values.hint_answer}
                                            fieldError={errors.hint_answer}
                                            activeError={activeError}
                                            dispatch={dispatch}
                                        />
                                        <CaptchaField
                                            fieldState={states.captcha}
                                            fieldValue={values.captcha}
                                            fieldError={errors.captcha}
                                            activeError={activeError}
                                            captcha={captcha}
                                            settings={settings}
                                            dispatch={dispatch}
                                        />
                                    </div>
                                    <ToggleValidationMethodBtn toggleValidationMethod={this.toggleValidationMethod} />
                                </div>
                            );
                        }

                        return null;
                    })()}
                {form.captchaRequired && validation.method !== 'captcha' && (
                    <CaptchaField
                        fieldState={states.captcha}
                        fieldValue={values.captcha}
                        fieldError={errors.captcha}
                        activeError={activeError}
                        captcha={captcha}
                        settings={settings}
                        dispatch={dispatch}
                    />
                )}
                <div>
                    <div className='form__submit'>
                        {isFetching || this.isLoading ? (
                            <SpinnerComponent fetchingStatus={fetchingStatus} />
                        ) : (
                            extracted.submit.call(this)
                        )}
                    </div>
                    {registrationErrors.status === 'error' && (
                        <div data-t='connect:mobile-error'>
                            <strong>{registrationErrors.text}</strong>
                            <p dangerouslySetInnerHTML={{__html: registrationErrors.descriptionText}} />
                        </div>
                    )}
                </div>

                {registrationErrors.status === 'global' && <p className='error'>{registrationErrors.text}</p>}
            </form>
        );
    }
}

FormMobile.propTypes = {
    dispatch: PropTypes.func.isRequired,
    form: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    captcha: PropTypes.object.isRequired,
    isMobile: PropTypes.bool,
    isMobileCaptcha: PropTypes.bool,
    lang: PropTypes.string.isRequired,
    isFetching: PropTypes.bool.isRequired,
    registrationErrors: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    logins: PropTypes.object.isRequired
};
