import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import {Logo} from '@components/Logo';
//import Logo from '@blocks/registration/customizations/Logo.jsx';
import {Footer} from '@components/Footer/Footer.jsx';
import AuthType from './auth_type.jsx';
import {ServicesSVG} from './services';

export default class Promo extends PureComponent {
    renderFooter = (skipPromo) => {
        const {langlist, env, help, language, tld} = this.props;

        return (
            <Footer
                page={skipPromo ? 'registration_simple' : 'registration'}
                langlist={langlist}
                tld={tld}
                env={env}
                help={help}
                language={language}
            />
        );
    };

    getRegErrorText = (registrationErrors) => (
        <div>
            <strong>{registrationErrors.text}</strong>
            <p dangerouslySetInnerHTML={{__html: registrationErrors.descriptionText}} />
        </div>
    );

    render() {
        const {
            registrationErrors,
            isFetching,
            displayName,
            provider,
            prefix,
            servicesList,
            authURL,
            title,
            description,
            hideDescription,
            skipPromo
        } = this.props;

        if (skipPromo) {
            return this.renderFooter(skipPromo);
        }

        return (
            <div className='presentation'>
                <ServicesSVG />
                <div className='presentation__wrapper complete__presentation'>
                    <div className='yaLogo-wrap'>
                        <Logo isStatic={true} className='yaLogo' />
                    </div>
                    <h2 className='description__text'>{i18n('Frontend.registration_main-title_id')}</h2>

                    {!hideDescription && <h2 className='description__text'>{title}</h2>}
                    <ul className='services__icons'>
                        {servicesList.map((service) => (
                            <li className={`service__icon icon-${service}`} key={service}>
                                <svg>
                                    <use xlinkHref={`#${service}`} />
                                </svg>
                            </li>
                        ))}
                    </ul>
                    <div className='presentation__about'>
                        {
                            {
                                ok: description,
                                error: this.getRegErrorText(registrationErrors)
                            }[registrationErrors.status]
                        }
                    </div>
                    {displayName && (
                        <AuthType provider={provider} displayName={displayName} prefix={prefix} authURL={authURL} />
                    )}
                    <div className='fetching-block'>
                        <Spin progress={isFetching} size='l' />
                    </div>
                </div>
                {this.renderFooter()}
            </div>
        );
    }
}

Promo.propTypes = {
    hideDescription: PropTypes.bool,
    langlist: PropTypes.array.isRequired,
    env: PropTypes.object,
    help: PropTypes.object.isRequired,
    language: PropTypes.string.isRequired,
    tld: PropTypes.string.isRequired,
    registrationErrors: PropTypes.object.isRequired,
    isFetching: PropTypes.bool.isRequired,
    provider: PropTypes.string,
    displayName: PropTypes.string,
    prefix: PropTypes.string.isRequired,
    servicesList: PropTypes.array.isRequired,
    authURL: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    description: PropTypes.string.isRequired,
    skipPromo: PropTypes.bool
};
